/*
 * Decompiled with CFR 0.152.
 */
package com.lukeonuke.model;

import com.lukeonuke.service.InventoryUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name="shops", indexes={@Index(name="idx_position", columnList="position")})
public class ShopModel {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;
    @Column(nullable=false)
    private String position;
    @Column(nullable=false)
    private UUID owner;
    @Column(nullable=false, length=1024)
    private String item;
    @Column(nullable=false)
    private int itemAmount;
    @Column(nullable=false, length=1024)
    private String price;
    @Column(nullable=false)
    private int priceAmount;
    @Column(nullable=false)
    private String storagePricePos;
    @Column(nullable=false)
    private String storageItemPos;
    @CreationTimestamp
    @Column(updatable=false)
    private Instant createdAt;
    @Column(nullable=true)
    private Instant deletedAt;

    public class_1799 getPriceAsItemStack(class_1937 world) {
        return InventoryUtil.fromJson(this.getPrice(), world);
    }

    public class_1799 getItemAsItemStack(class_1937 world) {
        return InventoryUtil.fromJson(this.getItem(), world);
    }

    public String toString() {
        return "ShopModel{id=" + this.id + ", position='" + this.position + "', owner=" + String.valueOf(this.owner) + ", item='" + this.item + "', itemAmount=" + this.itemAmount + ", price='" + this.price + "', priceAmount=" + this.priceAmount + ", storagePricePos='" + this.storagePricePos + "', storageItemPos='" + this.storageItemPos + "', createdAt=" + String.valueOf(this.createdAt) + ", deletedAt=" + String.valueOf(this.deletedAt) + "}";
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getPosition() {
        return this.position;
    }

    @Generated
    public UUID getOwner() {
        return this.owner;
    }

    @Generated
    public String getItem() {
        return this.item;
    }

    @Generated
    public int getItemAmount() {
        return this.itemAmount;
    }

    @Generated
    public String getPrice() {
        return this.price;
    }

    @Generated
    public int getPriceAmount() {
        return this.priceAmount;
    }

    @Generated
    public String getStoragePricePos() {
        return this.storagePricePos;
    }

    @Generated
    public String getStorageItemPos() {
        return this.storageItemPos;
    }

    @Generated
    public Instant getDeletedAt() {
        return this.deletedAt;
    }

    @Generated
    public void setPosition(String position) {
        this.position = position;
    }

    @Generated
    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Generated
    public void setItem(String item) {
        this.item = item;
    }

    @Generated
    public void setItemAmount(int itemAmount) {
        this.itemAmount = itemAmount;
    }

    @Generated
    public void setPrice(String price) {
        this.price = price;
    }

    @Generated
    public void setPriceAmount(int priceAmount) {
        this.priceAmount = priceAmount;
    }

    @Generated
    public void setStoragePricePos(String storagePricePos) {
        this.storagePricePos = storagePricePos;
    }

    @Generated
    public void setStorageItemPos(String storageItemPos) {
        this.storageItemPos = storageItemPos;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public void setDeletedAt(Instant deletedAt) {
        this.deletedAt = deletedAt;
    }
}

