/*
 * Decompiled with CFR 0.152.
 */
package com.lukeonuke.service;

import com.lukeonuke.SignShop;
import com.lukeonuke.model.ShopModel;
import com.lukeonuke.model.TransactionModel;
import com.lukeonuke.service.ConfigurationService;
import com.lukeonuke.service.ShopPosition;
import java.time.Instant;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;

public class DatabaseService {
    private final SessionFactory sessionFactory;
    private static DatabaseService instance = null;

    public static DatabaseService getInstance() {
        if (instance == null) {
            instance = new DatabaseService();
        }
        return instance;
    }

    private DatabaseService() {
        Configuration configuration = new Configuration();
        ConfigurationService cs = ConfigurationService.getInstance();
        configuration.setProperty("hibernate.connection.driver_class", "com.mysql.cj.jdbc.Driver");
        configuration.setProperty("hibernate.connection.url", cs.getDBUrl());
        configuration.setProperty("hibernate.connection.username", cs.getDBUser());
        configuration.setProperty("hibernate.connection.password", cs.getDBPassword());
        configuration.setProperty("hibernate.format_sql", "true");
        configuration.setProperty("hibernate.hbm2ddl.auto", "update");
        configuration.addAnnotatedClass(ShopModel.class);
        configuration.addAnnotatedClass(TransactionModel.class);
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings(configuration.getProperties()).build();
        this.sessionFactory = configuration.buildSessionFactory(serviceRegistry);
        SignShop.LOGGER.info("        Setup database session factory!");
    }

    private Session getSession() {
        return this.sessionFactory.openSession();
    }

    public ShopModel getShopById(int id) {
        try (Session session = this.getSession();){
            ShopModel shopModel = session.find(ShopModel.class, (Object)id);
            return shopModel;
        }
    }

    public void insertTransaction(TransactionModel transaction) {
        try (Session session = this.getSession();){
            Transaction tx = session.beginTransaction();
            session.persist(transaction);
            tx.commit();
        }
    }

    public void insertShop(ShopModel shop) {
        try (Session session = this.getSession();){
            Transaction tx = session.beginTransaction();
            session.persist(shop);
            tx.commit();
        }
    }

    public ShopModel getShopByPosition(ShopPosition position) {
        return this.getShopByPosition(position.toString());
    }

    public ShopModel getShopByPosition(String position) {
        try (Session session = this.getSession();){
            String hql = "from ShopModel s where s.position = :position AND s.deletedAt IS NULL";
            ShopModel shopModel = (ShopModel)session.createQuery(hql, ShopModel.class).setParameter("position", (Object)position).uniqueResult();
            return shopModel;
        }
    }

    public void softDeleteShopById(int id) {
        try (Session session = this.getSession();){
            Transaction tx = session.beginTransaction();
            ShopModel shop = session.find(ShopModel.class, (Object)id);
            if (shop != null) {
                shop.setDeletedAt(Instant.now());
                session.merge(shop);
            }
            tx.commit();
        }
    }

    public void softDeleteShopByPosition(String position) {
        try (Session session = this.getSession();){
            Transaction tx = session.beginTransaction();
            ShopModel shop = (ShopModel)session.createQuery("from ShopModel s where s.position = :pos", ShopModel.class).setParameter("pos", (Object)position).uniqueResult();
            if (shop != null) {
                shop.setDeletedAt(Instant.now());
                session.merge(shop);
            }
            tx.commit();
        }
    }
}

