/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.EntityResult;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.QueryHint;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedNativeQueryImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.QueryProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.MutableClassDetails;

public class NamedNativeQueryJpaAnnotation
implements NamedNativeQuery {
    private String name;
    private String query;
    private QueryHint[] hints;
    private Class<?> resultClass;
    private String resultSetMapping;
    private EntityResult[] entities;
    private ConstructorResult[] classes;
    private ColumnResult[] columns;

    public NamedNativeQueryJpaAnnotation(ModelsContext modelContext) {
        this.hints = new QueryHint[0];
        this.resultClass = Void.TYPE;
        this.resultSetMapping = "";
        this.entities = new EntityResult[0];
        this.classes = new ConstructorResult[0];
        this.columns = new ColumnResult[0];
    }

    public NamedNativeQueryJpaAnnotation(NamedNativeQuery annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.query = annotation.query();
        this.hints = (QueryHint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "hints", modelContext);
        this.resultClass = annotation.resultClass();
        this.resultSetMapping = annotation.resultSetMapping();
        this.entities = (EntityResult[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "entities", modelContext);
        this.classes = (ConstructorResult[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "classes", modelContext);
        this.columns = (ColumnResult[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "columns", modelContext);
    }

    public NamedNativeQueryJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.query = (String)attributeValues.get("query");
        this.hints = (QueryHint[])attributeValues.get("hints");
        this.resultClass = (Class)attributeValues.get("resultClass");
        this.resultSetMapping = (String)attributeValues.get("resultSetMapping");
        this.entities = (EntityResult[])attributeValues.get("entities");
        this.classes = (ConstructorResult[])attributeValues.get("classes");
        this.columns = (ColumnResult[])attributeValues.get("columns");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return NamedNativeQuery.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public String query() {
        return this.query;
    }

    public void query(String value) {
        this.query = value;
    }

    @Override
    public QueryHint[] hints() {
        return this.hints;
    }

    public void hints(QueryHint[] value) {
        this.hints = value;
    }

    @Override
    public Class<?> resultClass() {
        return this.resultClass;
    }

    public void resultClass(Class<?> value) {
        this.resultClass = value;
    }

    @Override
    public String resultSetMapping() {
        return this.resultSetMapping;
    }

    public void resultSetMapping(String value) {
        this.resultSetMapping = value;
    }

    @Override
    public EntityResult[] entities() {
        return this.entities;
    }

    public void entities(EntityResult[] value) {
        this.entities = value;
    }

    @Override
    public ConstructorResult[] classes() {
        return this.classes;
    }

    public void classes(ConstructorResult[] value) {
        this.classes = value;
    }

    @Override
    public ColumnResult[] columns() {
        return this.columns;
    }

    public void columns(ColumnResult[] value) {
        this.columns = value;
    }

    public void apply(JaxbNamedNativeQueryImpl jaxbNamedQuery, XmlDocumentContext xmlDocumentContext) {
        this.name(jaxbNamedQuery.getName());
        this.query(jaxbNamedQuery.getQuery());
        this.hints(QueryProcessing.collectQueryHints(jaxbNamedQuery.getHints(), xmlDocumentContext));
        if (StringHelper.isNotEmpty(jaxbNamedQuery.getResultClass())) {
            MutableClassDetails resultClassDetails = xmlDocumentContext.resolveJavaType(jaxbNamedQuery.getResultClass());
            this.resultClass(resultClassDetails.toJavaClass());
        }
        if (StringHelper.isNotEmpty(jaxbNamedQuery.getResultSetMapping())) {
            this.resultSetMapping(jaxbNamedQuery.getResultSetMapping());
        }
        this.columns(QueryProcessing.extractColumnResults(jaxbNamedQuery.getColumnResult(), xmlDocumentContext));
        this.classes(QueryProcessing.extractConstructorResults(jaxbNamedQuery.getConstructorResult(), xmlDocumentContext));
        this.entities(QueryProcessing.extractEntityResults(jaxbNamedQuery.getEntityResult(), xmlDocumentContext));
    }
}

