/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.QueryHint;
import jakarta.persistence.StoredProcedureParameter;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedStoredProcedureQueryImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.QueryProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.models.spi.ModelsContext;

public class NamedStoredProcedureQueryJpaAnnotation
implements NamedStoredProcedureQuery {
    private String name;
    private String procedureName;
    private StoredProcedureParameter[] parameters;
    private Class[] resultClasses;
    private String[] resultSetMappings;
    private QueryHint[] hints;

    public NamedStoredProcedureQueryJpaAnnotation(ModelsContext modelContext) {
        this.parameters = new StoredProcedureParameter[0];
        this.resultClasses = new Class[0];
        this.resultSetMappings = new String[0];
        this.hints = new QueryHint[0];
    }

    public NamedStoredProcedureQueryJpaAnnotation(NamedStoredProcedureQuery annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.procedureName = annotation.procedureName();
        this.parameters = (StoredProcedureParameter[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, "parameters", modelContext);
        this.resultClasses = annotation.resultClasses();
        this.resultSetMappings = annotation.resultSetMappings();
        this.hints = (QueryHint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, "hints", modelContext);
    }

    public NamedStoredProcedureQueryJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.procedureName = (String)attributeValues.get("procedureName");
        this.parameters = (StoredProcedureParameter[])attributeValues.get("parameters");
        this.resultClasses = (Class[])attributeValues.get("resultClasses");
        this.resultSetMappings = (String[])attributeValues.get("resultSetMappings");
        this.hints = (QueryHint[])attributeValues.get("hints");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return NamedStoredProcedureQuery.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public String procedureName() {
        return this.procedureName;
    }

    public void procedureName(String value) {
        this.procedureName = value;
    }

    @Override
    public StoredProcedureParameter[] parameters() {
        return this.parameters;
    }

    public void parameters(StoredProcedureParameter[] value) {
        this.parameters = value;
    }

    @Override
    public Class[] resultClasses() {
        return this.resultClasses;
    }

    public void resultClasses(Class[] value) {
        this.resultClasses = value;
    }

    @Override
    public String[] resultSetMappings() {
        return this.resultSetMappings;
    }

    public void resultSetMappings(String[] value) {
        this.resultSetMappings = value;
    }

    @Override
    public QueryHint[] hints() {
        return this.hints;
    }

    public void hints(QueryHint[] value) {
        this.hints = value;
    }

    public void apply(JaxbNamedStoredProcedureQueryImpl jaxbQuery, XmlDocumentContext xmlDocumentContext) {
        this.name(jaxbQuery.getName());
        this.procedureName(jaxbQuery.getProcedureName());
        this.hints(QueryProcessing.collectQueryHints(jaxbQuery.getHints(), xmlDocumentContext));
        this.parameters(QueryProcessing.collectParameters(jaxbQuery.getProcedureParameters(), xmlDocumentContext));
        this.resultClasses(QueryProcessing.collectResultClasses(jaxbQuery.getResultClasses(), xmlDocumentContext));
        this.resultSetMappings(QueryProcessing.collectResultMappings(jaxbQuery.getResultClasses(), xmlDocumentContext));
    }
}

