/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbElementCollectionImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.XmlAnnotations;
import org.hibernate.boot.models.annotations.internal.CollectionTableJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.ElementCollectionJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TargetXmlAnnotation;
import org.hibernate.boot.models.xml.internal.SimpleTypeInterpretation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonPluralAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class ElementCollectionAttributeProcessing {
    public static MutableMemberDetails processElementCollectionAttribute(JaxbElementCollectionImpl jaxbElementCollection, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbElementCollection.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbElementCollection.getName(), accessType, declarer);
        ElementCollectionJpaAnnotation elementCollectionUsage = (ElementCollectionJpaAnnotation)memberDetails.applyAnnotationUsage(JpaAnnotations.ELEMENT_COLLECTION, xmlDocumentContext.getModelBuildingContext());
        if (jaxbElementCollection.getFetch() != null) {
            elementCollectionUsage.fetch(jaxbElementCollection.getFetch());
        }
        ElementCollectionAttributeProcessing.applyElementCollectionElementType(jaxbElementCollection, elementCollectionUsage, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyConverts(jaxbElementCollection.getConverts(), null, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAccess(accessType, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeAccessor(jaxbElementCollection, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyFetching(jaxbElementCollection, memberDetails, elementCollectionUsage, xmlDocumentContext);
        CommonAttributeProcessing.applyOptimisticLock(jaxbElementCollection, memberDetails, xmlDocumentContext);
        CommonPluralAttributeProcessing.applyPluralAttributeStructure(jaxbElementCollection, memberDetails, xmlDocumentContext);
        ElementCollectionAttributeProcessing.applyCollectionTable(jaxbElementCollection.getCollectionTable(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyColumn(jaxbElementCollection.getColumn(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyEnumerated(jaxbElementCollection.getEnumerated(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLob(jaxbElementCollection.getLob(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyNationalized(jaxbElementCollection.getNationalized(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyTemporal(jaxbElementCollection.getTemporal(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyBasicTypeComposition(jaxbElementCollection, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAttributeOverrides(jaxbElementCollection, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAssociationOverrides(jaxbElementCollection.getAssociationOverrides(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }

    private static void applyElementCollectionElementType(JaxbElementCollectionImpl jaxbElementCollection, ElementCollectionJpaAnnotation elementCollectionUsage, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        SimpleTypeInterpretation simpleTypeInterpretation;
        if (StringHelper.isNotEmpty(jaxbElementCollection.getTargetClass()) && (simpleTypeInterpretation = SimpleTypeInterpretation.interpret(jaxbElementCollection.getTargetClass())) != null) {
            elementCollectionUsage.targetClass(simpleTypeInterpretation.getJavaType());
            return;
        }
        ElementCollectionAttributeProcessing.applyTarget(jaxbElementCollection, xmlDocumentContext, memberDetails);
    }

    private static void applyTarget(JaxbElementCollectionImpl jaxbElementCollection, XmlDocumentContext xmlDocumentContext, MutableMemberDetails memberDetails) {
        String targetClass = jaxbElementCollection.getTargetClass();
        if (StringHelper.isNotEmpty(targetClass)) {
            TargetXmlAnnotation targetUsage = (TargetXmlAnnotation)memberDetails.applyAnnotationUsage(XmlAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
            targetUsage.value(xmlDocumentContext.resolveClassName(targetClass));
        }
    }

    public static void applyCollectionTable(JaxbCollectionTableImpl jaxbCollectionTable, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbCollectionTable == null) {
            return;
        }
        CollectionTableJpaAnnotation collectionTableAnn = (CollectionTableJpaAnnotation)memberDetails.applyAnnotationUsage(JpaAnnotations.COLLECTION_TABLE, xmlDocumentContext.getModelBuildingContext());
        collectionTableAnn.apply(jaxbCollectionTable, xmlDocumentContext);
    }
}

