/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry.selector.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.selector.internal.LazyServiceResolver;
import org.hibernate.boot.registry.selector.spi.NamedStrategyContributions;
import org.hibernate.boot.registry.selector.spi.NamedStrategyContributor;
import org.hibernate.boot.registry.selector.spi.StrategyCreator;
import org.hibernate.boot.registry.selector.spi.StrategySelectionException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.jboss.logging.Logger;

public class StrategySelectorImpl
implements StrategySelector {
    private static final Logger log = Logger.getLogger(StrategySelectorImpl.class);
    private static final StrategyCreator<?> STANDARD_STRATEGY_CREATOR = StrategySelectorImpl::create;
    private final Map<Class<?>, Map<String, Class<?>>> namedStrategyImplementorByStrategyMap = new ConcurrentHashMap();
    private final Map<Class<?>, LazyServiceResolver<?>> lazyStrategyImplementorByStrategyMap = new ConcurrentHashMap();
    private final ClassLoaderService classLoaderService;
    private final Collection<NamedStrategyContributor> contributors;

    public StrategySelectorImpl(ClassLoaderService classLoaderService) {
        this.classLoaderService = classLoaderService;
        this.contributors = classLoaderService.loadJavaServices(NamedStrategyContributor.class);
        for (NamedStrategyContributor contributor : this.contributors) {
            contributor.contributeStrategyImplementations(new StartupContributions());
        }
    }

    @Override
    public <T> Class<? extends T> selectStrategyImplementor(Class<T> strategy, String name) {
        Class<?> resolve;
        Class<?> registered;
        Map<String, Class<?>> namedStrategyImplementorMap = this.namedStrategyImplementorByStrategyMap.get(strategy);
        if (namedStrategyImplementorMap != null && (registered = namedStrategyImplementorMap.get(name)) != null) {
            return registered;
        }
        LazyServiceResolver<?> lazyServiceResolver = this.lazyStrategyImplementorByStrategyMap.get(strategy);
        if (lazyServiceResolver != null && (resolve = lazyServiceResolver.resolve(name)) != null) {
            return resolve;
        }
        try {
            return this.classLoaderService.classForName(name);
        }
        catch (ClassLoadingException e) {
            throw new StrategySelectionException("Unable to resolve name [" + name + "] as strategy [" + strategy.getName() + "]", e);
        }
    }

    @Override
    public <T> T resolveStrategy(Class<T> strategy, Object strategyReference) {
        return this.resolveDefaultableStrategy(strategy, strategyReference, (T)null);
    }

    @Override
    public <T> T resolveDefaultableStrategy(Class<T> strategy, Object strategyReference, T defaultValue) {
        return (T)this.resolveDefaultableStrategy(strategy, strategyReference, () -> defaultValue);
    }

    @Override
    public <T> T resolveDefaultableStrategy(Class<T> strategy, Object strategyReference, Callable<T> defaultResolver) {
        return this.resolveStrategy(strategy, strategyReference, defaultResolver, STANDARD_STRATEGY_CREATOR);
    }

    @Override
    public <T> T resolveStrategy(Class<T> strategy, Object strategyReference, T defaultValue, StrategyCreator<T> creator) {
        return (T)this.resolveStrategy(strategy, strategyReference, () -> defaultValue, creator);
    }

    @Override
    public <T> Collection<Class<? extends T>> getRegisteredStrategyImplementors(Class<T> strategy) {
        LazyServiceResolver<?> lazyServiceResolver = this.lazyStrategyImplementorByStrategyMap.get(strategy);
        if (lazyServiceResolver != null) {
            throw new StrategySelectionException("Can't use this method on for strategy types which are embedded in the core library");
        }
        Map<String, Class<?>> registrations = this.namedStrategyImplementorByStrategyMap.get(strategy);
        if (registrations == null) {
            return Collections.emptySet();
        }
        return new HashSet<Class<? extends T>>(registrations.values());
    }

    @Override
    public <T> T resolveStrategy(Class<T> strategy, Object strategyReference, Callable<T> defaultResolver, StrategyCreator<T> creator) {
        if (strategyReference == null) {
            try {
                return defaultResolver.call();
            }
            catch (Exception e) {
                throw new StrategySelectionException("Default-resolver threw exception", e);
            }
        }
        if (strategy.isInstance(strategyReference)) {
            return strategy.cast(strategyReference);
        }
        Class<T> implementationClass = strategyReference instanceof Class ? (Class<T>)strategyReference : this.selectStrategyImplementor(strategy, strategyReference.toString());
        try {
            return creator.create(implementationClass);
        }
        catch (Exception e) {
            throw new StrategySelectionException(String.format("Could not instantiate named strategy class [%s]", implementationClass.getName()), e);
        }
    }

    private static <T> T create(Class<T> strategyClass) {
        try {
            return strategyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new StrategySelectionException(String.format("Could not instantiate named strategy class [%s]", strategyClass.getName()), e);
        }
    }

    public <T> void registerStrategyLazily(Class<T> strategy, LazyServiceResolver<T> resolver) {
        LazyServiceResolver<T> previous = this.lazyStrategyImplementorByStrategyMap.put(strategy, resolver);
        if (previous != null) {
            throw new HibernateException("Detected a second LazyServiceResolver replacing an existing LazyServiceResolver implementation for strategy " + strategy.getName());
        }
    }

    private <T> void contributeImplementation(Class<T> strategy, Class<? extends T> implementation, String ... names) {
        Map namedStrategyImplementorMap = this.namedStrategyImplementorByStrategyMap.computeIfAbsent(strategy, clazz -> new ConcurrentHashMap());
        for (String name : names) {
            Class<T> old = namedStrategyImplementorMap.put(name, implementation);
            if (!log.isTraceEnabled()) continue;
            if (old == null) {
                log.tracef("Strategy selector for %s: '%s' -> %s", (Object)strategy.getSimpleName(), (Object)name, (Object)implementation.getName());
                continue;
            }
            log.tracef("Strategy selector for %s: '%s' -> %s (replacing %s)", strategy.getSimpleName(), name, implementation.getName(), old.getName());
        }
    }

    private <T> void removeImplementation(Class<T> strategy, Class<? extends T> implementation) {
        Map<String, Class<?>> namedStrategyImplementorMap = this.namedStrategyImplementorByStrategyMap.get(strategy);
        if (namedStrategyImplementorMap == null) {
            log.debug("Named strategy map did not exist on call to unregister");
            return;
        }
        Iterator<Class<?>> itr = namedStrategyImplementorMap.values().iterator();
        while (itr.hasNext()) {
            Class<?> registered = itr.next();
            if (!registered.equals(implementation)) continue;
            itr.remove();
        }
        if (namedStrategyImplementorMap.isEmpty()) {
            this.namedStrategyImplementorByStrategyMap.remove(strategy);
        }
    }

    @Override
    public void stop() {
        for (NamedStrategyContributor contributor : this.contributors) {
            contributor.clearStrategyImplementations(new ShutdownContributions());
        }
    }

    @Override
    public <T> void registerStrategyImplementor(Class<T> strategy, String name, Class<? extends T> implementation) {
        this.contributeImplementation(strategy, implementation, name);
    }

    @Override
    public <T> void unRegisterStrategyImplementor(Class<T> strategy, Class<? extends T> implementation) {
        this.removeImplementation(strategy, implementation);
    }

    private class StartupContributions
    implements NamedStrategyContributions {
        private StartupContributions() {
        }

        @Override
        public <T> void contributeStrategyImplementor(Class<T> strategy, Class<? extends T> implementation, String ... names) {
            StrategySelectorImpl.this.contributeImplementation(strategy, implementation, names);
        }

        @Override
        public <T> void removeStrategyImplementor(Class<T> strategy, Class<? extends T> implementation) {
            StrategySelectorImpl.this.removeImplementation(strategy, implementation);
        }
    }

    private class ShutdownContributions
    extends StartupContributions {
        private ShutdownContributions() {
        }

        @Override
        public <T> void contributeStrategyImplementor(Class<T> strategy, Class<? extends T> implementation, String ... names) {
            throw new IllegalStateException("Should not register strategies during shutdown");
        }
    }
}

