/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import jakarta.persistence.metamodel.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.StubMethod;
import net.bytebuddy.matcher.ElementMatchers;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.Version;
import org.hibernate.bytecode.enhance.VersionMismatchException;
import org.hibernate.bytecode.enhance.internal.bytebuddy.ByteBuddyEnhancementContext;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CodeTemplates;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerClassLocator;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerImplConstants;
import org.hibernate.bytecode.enhance.internal.bytebuddy.FeatureMismatchException;
import org.hibernate.bytecode.enhance.internal.bytebuddy.ModelTypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.PersistentAttributeTransformer;
import org.hibernate.bytecode.enhance.internal.tracker.CompositeOwnerTracker;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.bytecode.enhance.spi.UnsupportedEnhancementStrategy;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.bytecode.internal.bytebuddy.ByteBuddyState;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.Managed;
import org.hibernate.engine.spi.ManagedComposite;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.ManagedMappedSuperclass;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class EnhancerImpl
implements Enhancer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Enhancer.class);
    protected final ByteBuddyEnhancementContext enhancementContext;
    private final ByteBuddyState byteBuddyState;
    private final EnhancerClassLocator typePool;
    private final EnhancerImplConstants constants;
    private final List<? extends Annotation> infoAnnotationList;
    private static final Set<String> IGNORED_PERSISTENCE_ANNOTATIONS = Set.of("jakarta.persistence.PostLoad", "jakarta.persistence.PostPersist", "jakarta.persistence.PostRemove", "jakarta.persistence.PostUpdate", "jakarta.persistence.PrePersist", "jakarta.persistence.PreRemove", "jakarta.persistence.PreUpdate");

    public EnhancerImpl(EnhancementContext enhancementContext, ByteBuddyState byteBuddyState) {
        this(enhancementContext, byteBuddyState, ModelTypePool.buildModelTypePool(enhancementContext.getLoadingClassLoader()));
    }

    public EnhancerImpl(EnhancementContext enhancementContext, ByteBuddyState byteBuddyState, EnhancerClassLocator classLocator) {
        this.enhancementContext = new ByteBuddyEnhancementContext(enhancementContext);
        this.byteBuddyState = Objects.requireNonNull(byteBuddyState);
        this.typePool = Objects.requireNonNull(classLocator);
        this.constants = byteBuddyState.getEnhancerConstants();
        this.infoAnnotationList = List.of(EnhancerImpl.createInfoAnnotation(enhancementContext));
    }

    @Override
    public byte[] enhance(String className, byte[] originalBytes) throws EnhancementException {
        String safeClassName = className.replace('/', '.');
        this.typePool.registerClassNameAndBytes(safeClassName, originalBytes);
        try {
            TypeDescription typeDescription = this.typePool.describe(safeClassName).resolve();
            byte[] byArray = this.byteBuddyState.rewrite(this.typePool, safeClassName, byteBuddy -> this.doEnhance(() -> byteBuddy.ignore(ElementMatchers.isDefaultFinalizer()).redefine(typeDescription, this.typePool.asClassFileLocator()).annotateType(this.infoAnnotationList), typeDescription));
            return byArray;
        }
        catch (EnhancementException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new EnhancementException("Failed to enhance class " + className, e);
        }
        finally {
            this.typePool.deregisterClassNameAndBytes(safeClassName);
        }
    }

    @Override
    public void discoverTypes(String className, byte[] originalBytes) {
        if (originalBytes != null) {
            this.typePool.registerClassNameAndBytes(className, originalBytes);
        }
        try {
            TypeDescription typeDescription = this.typePool.describe(className).resolve();
            this.enhancementContext.registerDiscoveredType(typeDescription, Type.PersistenceType.ENTITY);
            this.enhancementContext.discoverCompositeTypes(typeDescription, this.typePool);
        }
        catch (RuntimeException e) {
            throw new EnhancementException("Failed to discover types for class " + className, e);
        }
        finally {
            this.typePool.deregisterClassNameAndBytes(className);
        }
    }

    private DynamicType.Builder<?> doEnhance(Supplier<DynamicType.Builder<?>> builderSupplier, TypeDescription managedCtClass) {
        if (this.alreadyEnhanced(managedCtClass)) {
            AnnotationDescription.Loadable<EnhancementInfo> infoAnnotation = managedCtClass.getDeclaredAnnotations().ofType(EnhancementInfo.class);
            if (infoAnnotation != null) {
                this.verifyReEnhancement(managedCtClass, infoAnnotation.load(), this.enhancementContext);
            }
            log.tracef("Skipping enhancement of [%s]: it's already annotated with @EnhancementInfo", (Object)managedCtClass.getName());
            return null;
        }
        if (managedCtClass.isInterface()) {
            log.tracef("Skipping enhancement of [%s]: it's an interface", (Object)managedCtClass.getName());
            return null;
        }
        if (managedCtClass.isRecord()) {
            log.tracef("Skipping enhancement of [%s]: it's a record", (Object)managedCtClass.getName());
            return null;
        }
        if (this.enhancementContext.isEntityClass(managedCtClass)) {
            if (EnhancerImpl.checkUnsupportedAttributeNaming(managedCtClass, this.enhancementContext)) {
                return null;
            }
            log.tracef("Enhancing [%s] as Entity", (Object)managedCtClass.getName());
            DynamicType.Builder<?> builder = builderSupplier.get();
            builder = builder.implement(new Type[]{ManagedEntity.class}).defineMethod("$$_hibernate_getEntityInstance", this.constants.TypeObject, this.constants.methodModifierPUBLIC).intercept(FixedValue.self());
            builder = this.addFieldWithGetterAndSetter(builder, this.constants.TypeEntityEntry, "$$_hibernate_entityEntryHolder", "$$_hibernate_getEntityEntry", "$$_hibernate_setEntityEntry");
            builder = this.addFieldWithGetterAndSetter(builder, this.constants.TypeManagedEntity, "$$_hibernate_previousManagedEntity", "$$_hibernate_getPreviousManagedEntity", "$$_hibernate_setPreviousManagedEntity");
            builder = this.addFieldWithGetterAndSetter(builder, this.constants.TypeManagedEntity, "$$_hibernate_nextManagedEntity", "$$_hibernate_getNextManagedEntity", "$$_hibernate_setNextManagedEntity");
            builder = this.addFieldWithGetterAndSetter(builder, this.constants.TypeBooleanPrimitive, "$$_hibernate_useTracker", "$$_hibernate_useTracker", "$$_hibernate_setUseTracker");
            builder = this.addFieldWithGetterAndSetter(builder, this.constants.TypeIntegerPrimitive, "$$_hibernate_instanceId", "$$_hibernate_getInstanceId", "$$_hibernate_setInstanceId");
            builder = this.addSetPersistenceInfoMethod(builder, this.constants.TypeEntityEntry, this.constants.TypeManagedEntity, this.constants.TypeIntegerPrimitive);
            builder = this.addInterceptorHandling(builder, managedCtClass);
            if (this.enhancementContext.doDirtyCheckingInline()) {
                List<AnnotatedFieldDescription> collectionFields = this.collectCollectionFields(managedCtClass);
                if (collectionFields.isEmpty()) {
                    builder = builder.implement(new Type[]{SelfDirtinessTracker.class}).defineField("$$_hibernate_tracker", (Type)((Object)DirtyTracker.class), this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod("$$_hibernate_trackChange", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class}).intercept(this.constants.implementationTrackChange).defineMethod("$$_hibernate_getDirtyAttributes", this.constants.Type_Array_String, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationGetDirtyAttributesWithoutCollections).defineMethod("$$_hibernate_hasDirtyAttributes", this.constants.TypeBooleanPrimitive, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationAreFieldsDirtyWithoutCollections).defineMethod("$$_hibernate_clearDirtyAttributes", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationClearDirtyAttributesWithoutCollections).defineMethod("$$_hibernate_suspendDirtyTracking", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(this.constants.TypeBooleanPrimitive).intercept(this.constants.implementationSuspendDirtyTracking).defineMethod("$$_hibernate_getCollectionTracker", this.constants.TypeCollectionTracker, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationGetCollectionTrackerWithoutCollections);
                } else {
                    builder = builder.implement(new Type[]{ExtendedSelfDirtinessTracker.class}).defineField("$$_hibernate_tracker", (Type)((Object)DirtyTracker.class), this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineField("$$_hibernate_collectionTracker", this.constants.TypeCollectionTracker, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod("$$_hibernate_trackChange", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class}).intercept(this.constants.implementationTrackChange).defineMethod("$$_hibernate_getDirtyAttributes", this.constants.Type_Array_String, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationGetDirtyAttributes).defineMethod("$$_hibernate_hasDirtyAttributes", this.constants.TypeBooleanPrimitive, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationAreFieldsDirty).defineMethod("$$_hibernate_clearDirtyAttributes", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationClearDirtyAttributes).defineMethod("$$_hibernate_suspendDirtyTracking", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(this.constants.TypeBooleanPrimitive).intercept(this.constants.implementationSuspendDirtyTracking).defineMethod("$$_hibernate_getCollectionTracker", this.constants.TypeCollectionTracker, this.constants.methodModifierPUBLIC).intercept(FieldAccessor.ofField("$$_hibernate_collectionTracker"));
                    Implementation isDirty = StubMethod.INSTANCE;
                    Implementation getDirtyNames = StubMethod.INSTANCE;
                    Implementation clearDirtyNames = StubMethod.INSTANCE;
                    for (AnnotatedFieldDescription collectionField : collectionFields) {
                        Class adviceClearDirtyNames;
                        Class adviceGetDirtyNames;
                        Class adviceIsDirty;
                        String collectionFieldName = collectionField.getName();
                        if (collectionField.getType().asErasure().isAssignableTo(Map.class)) {
                            adviceIsDirty = CodeTemplates.MapAreCollectionFieldsDirty.class;
                            adviceGetDirtyNames = CodeTemplates.MapGetCollectionFieldDirtyNames.class;
                            adviceClearDirtyNames = CodeTemplates.MapGetCollectionClearDirtyNames.class;
                        } else {
                            adviceIsDirty = CodeTemplates.CollectionAreCollectionFieldsDirty.class;
                            adviceGetDirtyNames = CodeTemplates.CollectionGetCollectionFieldDirtyNames.class;
                            adviceClearDirtyNames = CodeTemplates.CollectionGetCollectionClearDirtyNames.class;
                        }
                        if (collectionField.isVisibleTo(managedCtClass)) {
                            FieldDescription fieldDescription = collectionField.getFieldDescription();
                            isDirty = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, collectionFieldName).bind(CodeTemplates.FieldValue.class, fieldDescription).to(adviceIsDirty, this.constants.adviceLocator).wrap(isDirty);
                            getDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, collectionFieldName).bind(CodeTemplates.FieldValue.class, fieldDescription).to(adviceGetDirtyNames, this.constants.adviceLocator).wrap(getDirtyNames);
                            clearDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, collectionFieldName).bind(CodeTemplates.FieldValue.class, fieldDescription).to(adviceClearDirtyNames, this.constants.adviceLocator).wrap(clearDirtyNames);
                            continue;
                        }
                        CodeTemplates.GetterMapping getterMapping = new CodeTemplates.GetterMapping(collectionField.getFieldDescription());
                        isDirty = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, collectionFieldName).bind(CodeTemplates.FieldValue.class, getterMapping).to(adviceIsDirty, this.constants.adviceLocator).wrap(isDirty);
                        getDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, collectionFieldName).bind(CodeTemplates.FieldValue.class, getterMapping).to(adviceGetDirtyNames, this.constants.adviceLocator).wrap(getDirtyNames);
                        clearDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, collectionFieldName).bind(CodeTemplates.FieldValue.class, getterMapping).to(adviceClearDirtyNames, this.constants.adviceLocator).wrap(clearDirtyNames);
                    }
                    if (this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
                        clearDirtyNames = this.constants.adviceInitializeLazyAttributeLoadingInterceptor.wrap(clearDirtyNames);
                    }
                    builder = builder.defineMethod("$$_hibernate_areCollectionFieldsDirty", this.constants.TypeBooleanPrimitive, this.constants.methodModifierPUBLIC).intercept(isDirty).defineMethod("$$_hibernate_getCollectionFieldDirtyNames", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{DirtyTracker.class}).intercept(getDirtyNames).defineMethod("$$_hibernate_clearDirtyCollectionNames", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).intercept(Advice.withCustomMapping().to(CodeTemplates.ClearDirtyCollectionNames.class, this.constants.adviceLocator).wrap(StubMethod.INSTANCE)).defineMethod("$$_hibernate_removeDirtyFields", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{LazyAttributeLoadingInterceptor.class}).intercept(clearDirtyNames);
                }
            }
            return this.createTransformer(managedCtClass).applyTo(builder);
        }
        if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            if (EnhancerImpl.checkUnsupportedAttributeNaming(managedCtClass, this.enhancementContext)) {
                return null;
            }
            log.tracef("Enhancing [%s] as Composite", (Object)managedCtClass.getName());
            DynamicType.Builder<?> builder = builderSupplier.get();
            builder = builder.implement(new Type[]{ManagedComposite.class});
            builder = this.addInterceptorHandling(builder, managedCtClass);
            if (this.enhancementContext.doDirtyCheckingInline()) {
                builder = builder.implement(new Type[]{CompositeTracker.class}).defineField("$$_hibernate_compositeOwners", (Type)((Object)CompositeOwnerTracker.class), this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod("$$_hibernate_setOwner", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class, CompositeOwner.class}).intercept(this.constants.implementationSetOwner).defineMethod("$$_hibernate_clearOwner", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class}).intercept(this.constants.implementationClearOwner);
            }
            return this.createTransformer(managedCtClass).applyTo(builder);
        }
        if (this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            if (EnhancerImpl.checkUnsupportedAttributeNaming(managedCtClass, this.enhancementContext)) {
                return null;
            }
            log.tracef("Enhancing [%s] as MappedSuperclass", (Object)managedCtClass.getName());
            DynamicType.Builder<?> builder = builderSupplier.get();
            builder = builder.implement(new Type[]{ManagedMappedSuperclass.class});
            return this.createTransformer(managedCtClass).applyTo(builder);
        }
        if (this.enhancementContext.doExtendedEnhancement()) {
            log.tracef("Extended enhancement of [%s]", (Object)managedCtClass.getName());
            return this.createTransformer(managedCtClass).applyExtended(builderSupplier.get());
        }
        log.tracef("Skipping enhancement of [%s]: not entity or composite", (Object)managedCtClass.getName());
        return null;
    }

    private void verifyReEnhancement(TypeDescription managedCtClass, EnhancementInfo existingInfo, ByteBuddyEnhancementContext enhancementContext) {
        String enhancementVersion = existingInfo.version();
        if ("ignore".equals(enhancementVersion)) {
            log.debugf("Skipping re-enhancement version check for %s due to `ignore`", (Object)managedCtClass.getName());
        } else if (!Version.getVersionString().equals(enhancementVersion)) {
            throw new VersionMismatchException(managedCtClass, enhancementVersion, Version.getVersionString());
        }
        FeatureMismatchException.checkFeatureEnablement(managedCtClass, FeatureMismatchException.Feature.DIRTY_CHECK, enhancementContext.doDirtyCheckingInline(), existingInfo.includesDirtyChecking());
        FeatureMismatchException.checkFeatureEnablement(managedCtClass, FeatureMismatchException.Feature.ASSOCIATION_MANAGEMENT, enhancementContext.doBiDirectionalAssociationManagement(), existingInfo.includesAssociationManagement());
    }

    private static AccessType determineDefaultAccessType(TypeDefinition typeDefinition) {
        AnnotationList annotations;
        TypeDefinition candidate;
        for (candidate = typeDefinition; candidate != null && !candidate.represents((Type)((Object)Object.class)); candidate = candidate.getSuperClass()) {
            AnnotationDescription.Loadable<Access> access;
            annotations = candidate.asErasure().getDeclaredAnnotations();
            if (!EnhancerImpl.hasMappingAnnotation(annotations) || (access = annotations.ofType(Access.class)) == null) continue;
            return access.load().value();
        }
        for (candidate = typeDefinition; candidate != null && !candidate.represents((Type)((Object)Object.class)); candidate = candidate.getSuperClass()) {
            annotations = candidate.asErasure().getDeclaredAnnotations();
            if (!EnhancerImpl.hasMappingAnnotation(annotations)) continue;
            for (FieldDescription ctField : candidate.getDeclaredFields()) {
                AnnotationList annotationList;
                if (Modifier.isStatic(ctField.getModifiers()) || !(annotationList = ctField.getDeclaredAnnotations()).isAnnotationPresent(Id.class) && !annotationList.isAnnotationPresent(EmbeddedId.class)) continue;
                return AccessType.FIELD;
            }
        }
        return AccessType.PROPERTY;
    }

    private static AccessType determineAccessType(AnnotationSource annotationSource, AccessType defaultAccessType) {
        AnnotationDescription.Loadable<Access> access = annotationSource.getDeclaredAnnotations().ofType(Access.class);
        return access != null ? access.load().value() : defaultAccessType;
    }

    private static boolean hasMappingAnnotation(AnnotationList annotations) {
        return annotations.isAnnotationPresent(Entity.class) || annotations.isAnnotationPresent(MappedSuperclass.class) || annotations.isAnnotationPresent(Embeddable.class);
    }

    private static boolean isPersistentMethod(MethodDescription method) {
        AnnotationList annotations = method.getDeclaredAnnotations();
        if (annotations.isAnnotationPresent(Transient.class)) {
            return false;
        }
        return annotations.stream().noneMatch(a -> IGNORED_PERSISTENCE_ANNOTATIONS.contains(a.getAnnotationType().getName()));
    }

    private static boolean containsField(TypeDescription.Generic type, String fieldName) {
        do {
            if (((FieldList)type.getDeclaredFields().filter(ElementMatchers.not(ElementMatchers.isStatic()).and(ElementMatchers.named(fieldName)))).isEmpty()) continue;
            return true;
        } while ((type = type.getSuperClass()) != null && !type.represents((Type)((Object)Object.class)));
        return false;
    }

    private static boolean checkUnsupportedAttributeNaming(TypeDescription managedCtClass, ByteBuddyEnhancementContext enhancementContext) {
        UnsupportedEnhancementStrategy strategy = enhancementContext.getUnsupportedEnhancementStrategy();
        if (UnsupportedEnhancementStrategy.LEGACY.equals((Object)strategy)) {
            return false;
        }
        AccessType defaultAccessType = EnhancerImpl.determineDefaultAccessType(managedCtClass);
        MethodList methods = (MethodList)MethodGraph.Compiler.DEFAULT.compile((TypeDefinition)managedCtClass).listNodes().asMethodList().filter(ElementMatchers.isGetter().or(ElementMatchers.isSetter()));
        for (MethodDescription methodDescription : methods) {
            String fieldName;
            if (methodDescription.getDeclaringType().represents((Type)((Object)Object.class)) || EnhancerImpl.determineAccessType(methodDescription, defaultAccessType) != AccessType.PROPERTY) continue;
            String methodName = methodDescription.getActualName();
            if (methodName.startsWith("get") || methodName.startsWith("set")) {
                fieldName = methodName.substring(3);
            } else {
                assert (methodName.startsWith("is"));
                fieldName = methodName.substring(2);
            }
            if ((fieldName = EnhancerImpl.getJavaBeansFieldName(fieldName)) == null || !EnhancerImpl.isPersistentMethod(methodDescription) || EnhancerImpl.containsField(managedCtClass.asGenericType(), fieldName)) continue;
            switch (strategy) {
                case SKIP: {
                    log.debugf("Skipping enhancement of [%s] because no field named [%s] could be found for property accessor method [%s]. To fix this, make sure all property accessor methods have a matching field.", (Object)managedCtClass.getName(), (Object)fieldName, (Object)methodDescription.getName());
                    break;
                }
                case FAIL: {
                    throw new EnhancementException(String.format("Enhancement of [%s] failed because no field named [%s] could be found for property accessor method [%s]. To fix this, make sure all property accessor methods have a matching field.", managedCtClass.getName(), fieldName, methodDescription.getName()));
                }
                default: {
                    throw new AssertionFailure("Unexpected strategy at this point: " + String.valueOf((Object)strategy));
                }
            }
            return true;
        }
        return false;
    }

    private static @Nullable String getJavaBeansFieldName(String name) {
        if (name.isEmpty()) {
            return null;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private PersistentAttributeTransformer createTransformer(TypeDescription typeDescription) {
        return PersistentAttributeTransformer.collectPersistentFields(typeDescription, this.enhancementContext, this.typePool);
    }

    private boolean alreadyEnhanced(TypeDescription managedCtClass) {
        for (TypeDescription.Generic declaredInterface : managedCtClass.getInterfaces()) {
            if (!declaredInterface.asErasure().isAssignableTo(Managed.class)) continue;
            return true;
        }
        return false;
    }

    private DynamicType.Builder<?> addInterceptorHandling(DynamicType.Builder<?> builder, TypeDescription managedCtClass) {
        if (this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
            log.tracef("Weaving in PersistentAttributeInterceptable implementation on [%s]", (Object)managedCtClass.getName());
            builder = builder.implement(new Type[]{PersistentAttributeInterceptable.class});
            builder = this.addFieldWithGetterAndSetter(builder, this.constants.TypePersistentAttributeInterceptor, "$$_hibernate_attributeInterceptor", "$$_hibernate_getInterceptor", "$$_hibernate_setInterceptor");
        }
        return builder;
    }

    private DynamicType.Builder<?> addFieldWithGetterAndSetter(DynamicType.Builder<?> builder, TypeDefinition type, String fieldName, String getterName, String setterName) {
        return builder.defineField(fieldName, type, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod(getterName, type, this.constants.methodModifierPUBLIC).intercept(FieldAccessor.ofField(fieldName)).defineMethod(setterName, this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(type).intercept(FieldAccessor.ofField(fieldName));
    }

    private DynamicType.Builder<?> addSetPersistenceInfoMethod(DynamicType.Builder<?> builder, TypeDefinition entityEntryType, TypeDefinition managedEntityType, TypeDefinition intType) {
        return builder.defineMethod("$$_hibernate_setPersistenceInfo", entityEntryType, this.constants.methodModifierPUBLIC).withParameters(entityEntryType, managedEntityType, managedEntityType, intType).intercept(this.constants.implementationSetPersistenceInfo);
    }

    private List<AnnotatedFieldDescription> collectCollectionFields(TypeDescription managedCtClass) {
        ArrayList<AnnotatedFieldDescription> collectionList = new ArrayList<AnnotatedFieldDescription>();
        for (FieldDescription fieldDescription : managedCtClass.getDeclaredFields()) {
            AnnotatedFieldDescription annotatedField;
            if (Modifier.isStatic(fieldDescription.getModifiers()) || fieldDescription.getName().startsWith("$$_hibernate_") || !this.enhancementContext.isPersistentField(annotatedField = new AnnotatedFieldDescription(this.enhancementContext, fieldDescription)) || !this.enhancementContext.isMappedCollection(annotatedField) || !fieldDescription.getType().asErasure().isAssignableTo(Collection.class) && !fieldDescription.getType().asErasure().isAssignableTo(Map.class)) continue;
            collectionList.add(annotatedField);
        }
        if (!this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            collectionList.addAll(this.collectInheritCollectionFields(managedCtClass));
        }
        return collectionList;
    }

    private Collection<AnnotatedFieldDescription> collectInheritCollectionFields(TypeDefinition managedCtClass) {
        TypeDescription.Generic managedCtSuperclass = managedCtClass.getSuperClass();
        if (managedCtSuperclass == null || managedCtSuperclass.represents((Type)((Object)Object.class))) {
            return Collections.emptyList();
        }
        if (!this.enhancementContext.isMappedSuperclassClass(managedCtSuperclass.asErasure())) {
            return this.collectInheritCollectionFields(managedCtSuperclass.asErasure());
        }
        ArrayList<AnnotatedFieldDescription> collectionList = new ArrayList<AnnotatedFieldDescription>();
        for (FieldDescription ctField : managedCtSuperclass.getDeclaredFields()) {
            AnnotatedFieldDescription annotatedField;
            if (Modifier.isStatic(ctField.getModifiers()) || !this.enhancementContext.isPersistentField(annotatedField = new AnnotatedFieldDescription(this.enhancementContext, ctField)) || !this.enhancementContext.isMappedCollection(annotatedField) || !ctField.getType().asErasure().isAssignableTo(Collection.class) && !ctField.getType().asErasure().isAssignableTo(Map.class)) continue;
            collectionList.add(annotatedField);
        }
        collectionList.addAll(this.collectInheritCollectionFields(managedCtSuperclass));
        return collectionList;
    }

    static String capitalize(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    private static EnhancementInfo createInfoAnnotation(EnhancementContext enhancementContext) {
        return new EnhancementInfoImpl(enhancementContext.doDirtyCheckingInline(), enhancementContext.doBiDirectionalAssociationManagement());
    }

    static class AnnotatedFieldDescription
    implements UnloadedField {
        private final ByteBuddyEnhancementContext context;
        private final FieldDescription fieldDescription;
        private AnnotationList annotations;
        private Optional<MethodDescription> getter;

        AnnotatedFieldDescription(ByteBuddyEnhancementContext context, FieldDescription fieldDescription) {
            this.context = context;
            this.fieldDescription = fieldDescription;
        }

        @Override
        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return this.getAnnotations().isAnnotationPresent(annotationType);
        }

        public String toString() {
            return this.fieldDescription.toString();
        }

        <T extends Annotation> AnnotationDescription.Loadable<T> getAnnotation(Class<T> annotationType) {
            return this.getAnnotations().ofType(annotationType);
        }

        String getName() {
            return this.fieldDescription.getName();
        }

        TypeDefinition getDeclaringType() {
            return this.fieldDescription.getDeclaringType();
        }

        TypeDescription.Generic getType() {
            return this.fieldDescription.getType();
        }

        FieldDescription.InDefinedShape asDefined() {
            return (FieldDescription.InDefinedShape)this.fieldDescription.asDefined();
        }

        String getDescriptor() {
            return this.fieldDescription.getDescriptor();
        }

        boolean isVisibleTo(TypeDescription typeDescription) {
            return this.fieldDescription.isVisibleTo(typeDescription);
        }

        FieldDescription getFieldDescription() {
            return this.fieldDescription;
        }

        Optional<MethodDescription> getGetter() {
            if (this.getter == null) {
                this.getter = this.context.resolveGetter(this.fieldDescription);
            }
            return this.getter;
        }

        private AnnotationList getAnnotations() {
            if (this.annotations == null) {
                this.annotations = this.doGetAnnotations();
            }
            return this.annotations;
        }

        private AnnotationList doGetAnnotations() {
            AnnotationDescription.Loadable<Access> access = this.fieldDescription.getDeclaringType().asErasure().getDeclaredAnnotations().ofType(Access.class);
            if (access != null && access.load().value() == AccessType.PROPERTY) {
                Optional<MethodDescription> getter = this.getGetter();
                if (getter.isPresent()) {
                    return getter.get().getDeclaredAnnotations();
                }
                return this.fieldDescription.getDeclaredAnnotations();
            }
            if (access != null && access.load().value() == AccessType.FIELD) {
                return this.fieldDescription.getDeclaredAnnotations();
            }
            Optional<MethodDescription> getter = this.getGetter();
            ArrayList<AnnotationDescription> annotationDescriptions = new ArrayList<AnnotationDescription>();
            if (getter.isPresent()) {
                annotationDescriptions.addAll(getter.get().getDeclaredAnnotations());
            }
            annotationDescriptions.addAll(this.fieldDescription.getDeclaredAnnotations());
            return new AnnotationList.Explicit(annotationDescriptions);
        }
    }

    private static class EnhancementInfoImpl
    implements EnhancementInfo {
        private final String version = Version.getVersionString();
        private final boolean includesDirtyChecking;
        private final boolean includesAssociationManagement;

        public EnhancementInfoImpl(boolean includesDirtyChecking, boolean includesAssociationManagement) {
            this.includesDirtyChecking = includesDirtyChecking;
            this.includesAssociationManagement = includesAssociationManagement;
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public boolean includesDirtyChecking() {
            return this.includesDirtyChecking;
        }

        @Override
        public boolean includesAssociationManagement() {
            return this.includesAssociationManagement;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return EnhancementInfo.class;
        }
    }
}

