/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.lang.invoke.MethodHandles;
import org.hibernate.Internal;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.id.table", description="Logging related to sequence-based identifier generation")
@Internal
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=90201, max=90300)
public interface SequenceGeneratorLogger
extends BasicLogger {
    public static final String NAME = "org.hibernate.orm.id.table";
    public static final Logger SEQUENCE_GENERATOR_LOGGER = Logger.getLogger("org.hibernate.orm.id.table");
    public static final SequenceGeneratorLogger SEQUENCE_GENERATOR_MESSAGE_LOGGER = Logger.getMessageLogger(MethodHandles.lookup(), SequenceGeneratorLogger.class, "org.hibernate.orm.id.table");

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Forcing table use for sequence-style generator due to pooled optimizer selection where db does not support pooled sequences", id=90201)
    public void forcingTableUse();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The increment size of the sequence '%s' is set to [%d] in the entity mapping while the associated database sequence increment size is [%d] - the database sequence increment size will take precedence to avoid identifier allocation conflicts.", id=90202)
    public void sequenceIncrementSizeMismatch(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Sequence-style generator configuration specified explicit optimizer [%s], but [%s=%s]; using optimizer [%s] increment default of [%s]", id=90203)
    public void honoringOptimizerSetting(String var1, String var2, int var3, String var4, int var5);
}

