/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.spi.ObjectFactory;
import org.hibernate.SessionFactory;
import org.hibernate.engine.jndi.JndiException;
import org.hibernate.engine.jndi.JndiNameException;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.SessionFactoryRegistryMessageLogger;
import org.hibernate.internal.util.StringHelper;

public class SessionFactoryRegistry {
    private static final SessionFactoryRegistryMessageLogger LOG = SessionFactoryRegistryMessageLogger.INSTANCE;
    public static final SessionFactoryRegistry INSTANCE = new SessionFactoryRegistry();
    private final ConcurrentHashMap<String, SessionFactoryImplementor> sessionFactoryMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> nameUuidXref = new ConcurrentHashMap();
    private final NamespaceChangeListener listener = new NamespaceChangeListener(){

        @Override
        public void objectAdded(NamingEvent evt) {
            if (LOG.isDebugEnabled()) {
                LOG.factoryBoundToJndi(evt.getNewBinding().getName());
            }
        }

        @Override
        public void objectRemoved(NamingEvent evt) {
            String jndiName = evt.getOldBinding().getName();
            LOG.factoryUnboundFromName(jndiName);
            String uuid = SessionFactoryRegistry.this.nameUuidXref.remove(jndiName);
            if (uuid != null) {
                SessionFactoryRegistry.this.sessionFactoryMap.remove(uuid);
            }
        }

        @Override
        public void objectRenamed(NamingEvent evt) {
            String oldJndiName = evt.getOldBinding().getName();
            String newJndiName = evt.getNewBinding().getName();
            LOG.factoryJndiRename(oldJndiName, newJndiName);
            String uuid = SessionFactoryRegistry.this.nameUuidXref.remove(oldJndiName);
            SessionFactoryRegistry.this.nameUuidXref.put(newJndiName, uuid);
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent evt) {
            LOG.namingExceptionAccessingFactory(evt.getException());
        }
    };

    private SessionFactoryRegistry() {
        LOG.tracef("Initializing SessionFactoryRegistry @%s", this.hashCode());
    }

    public void addSessionFactory(String uuid, String name, String jndiName, SessionFactoryImplementor instance, JndiService jndiService) {
        if (uuid == null) {
            throw new IllegalArgumentException("SessionFactory UUID cannot be null");
        }
        LOG.registeringSessionFactory(uuid, name == null ? "<unnamed>" : name);
        this.sessionFactoryMap.put(uuid, instance);
        if (name != null) {
            this.nameUuidXref.put(name, uuid);
        }
        if (jndiName == null) {
            LOG.notBindingSessionFactory();
            return;
        }
        this.bindToJndi(jndiName, instance, jndiService);
    }

    private void bindToJndi(String jndiName, SessionFactoryImplementor instance, JndiService jndiService) {
        try {
            LOG.attemptingToBindFactoryToJndi(jndiName);
            jndiService.bind(jndiName, instance);
            LOG.factoryBoundToJndiName(jndiName);
            try {
                jndiService.addListener(jndiName, this.listener);
            }
            catch (Exception e) {
                LOG.couldNotBindJndiListener();
            }
        }
        catch (JndiNameException e) {
            LOG.invalidJndiName(jndiName, e);
        }
        catch (JndiException e) {
            LOG.unableToBindFactoryToJndi(e);
        }
    }

    public void removeSessionFactory(String uuid, String name, String jndiName, JndiService jndiService) {
        if (name != null) {
            this.nameUuidXref.remove(name);
        }
        if (jndiName != null) {
            try {
                LOG.attemptingToUnbindFactoryFromJndi(jndiName);
                jndiService.unbind(jndiName);
                LOG.factoryUnboundFromJndiName(jndiName);
            }
            catch (JndiNameException e) {
                LOG.invalidJndiName(jndiName, e);
            }
            catch (JndiException e) {
                LOG.unableToUnbindFactoryFromJndi(e);
            }
        }
        this.sessionFactoryMap.remove(uuid);
    }

    public SessionFactoryImplementor getNamedSessionFactory(String name) {
        LOG.tracef("Lookup: name=%s", (Object)name);
        String uuid = this.nameUuidXref.get(name);
        return uuid == null ? null : this.getSessionFactory(uuid);
    }

    public SessionFactoryImplementor getSessionFactory(String uuid) {
        LOG.tracef("Lookup: uid=%s", (Object)uuid);
        SessionFactoryImplementor sessionFactory = this.sessionFactoryMap.get(uuid);
        if (sessionFactory == null && LOG.isDebugEnabled()) {
            LOG.debugf("Not found: %s", (Object)uuid);
            LOG.debug(this.sessionFactoryMap.toString());
        }
        return sessionFactory;
    }

    public SessionFactoryImplementor findSessionFactory(String uuid, String name) {
        SessionFactoryImplementor sessionFactory = this.getSessionFactory(uuid);
        return sessionFactory == null && StringHelper.isNotEmpty(name) ? this.getNamedSessionFactory(name) : sessionFactory;
    }

    public boolean hasRegistrations() {
        return !this.sessionFactoryMap.isEmpty();
    }

    public void clearRegistrations() {
        this.nameUuidXref.clear();
        for (SessionFactory sessionFactory : this.sessionFactoryMap.values()) {
            try {
                sessionFactory.close();
            }
            catch (Exception exception) {}
        }
        this.sessionFactoryMap.clear();
    }

    public static class ObjectFactoryImpl
    implements ObjectFactory {
        @Override
        public Object getObjectInstance(Object reference, Name name, Context nameCtx, Hashtable<?, ?> environment) {
            LOG.tracef("JNDI lookup: %s", (Object)name);
            String uuid = (String)((Reference)reference).get(0).getContent();
            LOG.tracef("Resolved to UUID = %s", (Object)uuid);
            return INSTANCE.getSessionFactory(uuid);
        }
    }
}

