/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.log;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import org.hibernate.Internal;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.deprecation", description="Logging related to uses of deprecated features")
@Internal
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=90000001, max=90001000)
public interface DeprecationLogger
extends BasicLogger {
    public static final String CATEGORY = "org.hibernate.orm.deprecation";
    public static final DeprecationLogger DEPRECATION_LOGGER = Logger.getMessageLogger(MethodHandles.lookup(), DeprecationLogger.class, "org.hibernate.orm.deprecation");

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="embed-xml attributes were intended to be used for DOM4J entity mode. Since that entity mode has been removed, embed-xml attributes are no longer supported and should be removed from mappings.", id=90000004)
    public void logDeprecationOfEmbedXmlSupport();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Defining an entity [%s] with no physical id attribute is no longer supported; please map the identifier to a physical entity attribute", id=90000005)
    public void logDeprecationOfNonNamedIdAttribute(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to specify unsupported NamingStrategy via command-line argument [--naming]. NamingStrategy has been removed in favor of the split ImplicitNamingStrategy and PhysicalNamingStrategy; use [--implicit-naming] or [--physical-naming], respectively, instead.", id=90000007)
    public void logDeprecatedNamingStrategyArgument();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to specify unsupported NamingStrategy via Ant task argument. NamingStrategy has been removed in favor of the split ImplicitNamingStrategy and PhysicalNamingStrategy.", id=90000008)
    public void logDeprecatedNamingStrategyAntArgument();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The outer-join attribute on <many-to-many> has been deprecated. Instead of outer-join=\"false\", use lazy=\"extra\" with <map>, <set>, <bag>, <idbag>, or <list>, which will only initialize entities (not as a proxy) as needed.", id=90000009)
    public void deprecatedManyToManyOuterJoin();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The fetch attribute on <many-to-many> has been deprecated. Instead of fetch=\"select\", use lazy=\"extra\" with <map>, <set>, <bag>, <idbag>, or <list>, which will only initialize entities (not as a proxy) as needed.", id=90000010)
    public void deprecatedManyToManyFetch();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Recognized obsolete hibernate namespace %s. Use namespace %s instead.  Support for obsolete DTD/XSD namespaces may be removed at any time.", id=90000012)
    public void recognizedObsoleteHibernateNamespace(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000018, value="Found use of deprecated transaction factory setting [%s]; use the new TransactionCoordinatorBuilder settings [%s] instead")
    public void logDeprecatedTransactionFactorySetting(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000021, value="Encountered deprecated setting [%s], use [%s] instead")
    public void deprecatedSetting(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000022, value="Encountered deprecated setting [%s]")
    public void deprecatedSetting(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s does not need to be specified explicitly using 'hibernate.dialect' (remove the property setting and it will be selected by default)", id=90000025)
    public void automaticDialect(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s has been deprecated", id=90000026)
    public void deprecatedDialect(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s has been deprecated; use %s instead", id=90000026)
    public void deprecatedDialect(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000028, value="Support for `<hibernate-mappings/>` is deprecated [%s : %s]; migrate to orm.xml or mapping.xml, or enable `hibernate.transform_hbm_xml.enabled` for on the fly transformation")
    public void logDeprecatedHbmXmlProcessing(SourceType var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000029, value="The [%s] configuration is deprecated and will be removed. Set the value to [%s] to get rid of this warning")
    public void deprecatedSettingForRemoval(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000030, value="The [%s] configuration is deprecated and will be removed.")
    public void deprecatedSettingNoReplacement(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000031, value="The native query colon escaping used for the [%s] operator is deprecated and will be removed. Use [%s] instead.")
    public void deprecatedNativeQueryColonEscaping(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000032, value="The support for passing arrays to array_contains() is deprecated and will be removed. Use array_includes() instead.")
    public void deprecatedArrayContainsWithArray();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000033, value="Encountered use of deprecated annotation [%s] at %s.")
    public void deprecatedAnnotation(Class<? extends Annotation> var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000034, value="Refreshing/locking detached entities is no longer allowed.")
    public void deprecatedRefreshLockDetachedEntity();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000035, value="Callback method annotated '@%s' declared by embeddable class '%s' relies on an undocumented and unsupported capability (lifecycle callback methods should be declared by entity classes)")
    public void embeddableLifecycleCallback(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000036, value="Encountered deprecated hint [%s]")
    public void deprecatedHint(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90000037, value="Encountered deprecated hint [%s], use [%s] instead")
    public void deprecatedHint(String var1, String var2);
}

