/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import org.hibernate.models.internal.AbstractAnnotationDescriptorRegistry;
import org.hibernate.models.internal.ModelsAnnotationLogging;
import org.hibernate.models.internal.MutableAnnotationDescriptorRegistry;
import org.hibernate.models.internal.StandardAnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.ModelsContext;

public class AnnotationDescriptorRegistryStandard
extends AbstractAnnotationDescriptorRegistry
implements MutableAnnotationDescriptorRegistry {
    private final ModelsContext modelsContext;

    public AnnotationDescriptorRegistryStandard(ModelsContext modelsContext) {
        this.modelsContext = modelsContext;
    }

    @Override
    public void register(AnnotationDescriptor<?> descriptor) {
        ModelsAnnotationLogging.MODELS_ANNOTATION_LOGGER.tracef("Registering AnnotationDescriptor - %s", (Object)descriptor);
        this.descriptorMap.put(descriptor.getAnnotationType(), descriptor);
        if (descriptor.getRepeatableContainer() != null) {
            ModelsAnnotationLogging.MODELS_ANNOTATION_LOGGER.tracef("Registering repeatable AnnotationDescriptor - %s", (Object)descriptor.getRepeatableContainer());
            this.repeatableByContainerMap.put(descriptor.getRepeatableContainer(), descriptor);
        }
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> getDescriptor(Class<A> javaType) {
        return this.resolveDescriptor(javaType, this::buildAdHocAnnotationDescriptor);
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> resolveDescriptor(Class<A> javaType, AnnotationDescriptorRegistry.DescriptorCreator<A> creator) {
        AnnotationDescriptor existing = (AnnotationDescriptor)this.descriptorMap.get(javaType);
        if (existing != null) {
            return existing;
        }
        AnnotationDescriptor<A> created = creator.createDescriptor(javaType);
        this.descriptorMap.put(javaType, created);
        return created;
    }

    private <A extends Annotation> AnnotationDescriptor<A> buildAdHocAnnotationDescriptor(Class<A> javaType) {
        AnnotationDescriptor<? extends Annotation> containerDescriptor;
        Repeatable repeatable = javaType.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            containerDescriptor = this.getDescriptor(repeatable.value());
            assert (containerDescriptor != null);
        } else {
            containerDescriptor = null;
        }
        AnnotationDescriptor<A> descriptor = this.buildAnnotationDescriptor(javaType, containerDescriptor);
        this.descriptorMap.put(javaType, descriptor);
        return descriptor;
    }

    protected <A extends Annotation> AnnotationDescriptor<A> buildAnnotationDescriptor(Class<A> javaType, AnnotationDescriptor<? extends Annotation> containerDescriptor) {
        return new StandardAnnotationDescriptor<A>(javaType, containerDescriptor, this.modelsContext);
    }
}

