/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.restriction;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.SingularAttribute;
import org.hibernate.query.range.Range;
import org.hibernate.query.restriction.Negation;
import org.hibernate.query.restriction.Restriction;

record NamedAttributeRange<X, U>(Class<X> entity, String attributeName, Range<U> range) implements Restriction<X>
{
    @Override
    public Restriction<X> negated() {
        return new Negation(this);
    }

    @Override
    public Predicate toPredicate(Root<? extends X> root, CriteriaBuilder builder) {
        Bindable entityType = root.getModel();
        if (!this.entity.isAssignableFrom(entityType.getJavaType())) {
            throw new IllegalArgumentException("Root entity is not a subtype of '" + this.entity.getTypeName() + "'");
        }
        Attribute attribute = entityType.getAttribute(this.attributeName);
        if (!(attribute instanceof SingularAttribute)) {
            throw new IllegalArgumentException("Attribute '" + this.attributeName + "' is not singular");
        }
        Class<U> rangeType = this.range.getType();
        if (rangeType != null && !rangeType.isAssignableFrom(attribute.getJavaType())) {
            throw new IllegalArgumentException("Attribute '" + this.attributeName + "' is not assignable to range of type '" + rangeType.getName() + "'");
        }
        return this.range.toPredicate(root.get(this.attributeName), builder);
    }
}

