/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableHelper;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.JdbcLogging;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.jboss.logging.Logger;

public class GlobalTemporaryTableStrategy {
    private static final Logger log = Logger.getLogger(GlobalTemporaryTableStrategy.class);
    public static final String SHORT_NAME = "global_temporary";
    public static final String CREATE_ID_TABLES = "hibernate.query.mutation_strategy.global_temporary.create_tables";
    public static final String DROP_ID_TABLES = "hibernate.query.mutation_strategy.global_temporary.drop_tables";
    private final TemporaryTable temporaryTable;
    private final SessionFactoryImplementor sessionFactory;
    private boolean prepared;
    private boolean dropIdTables;

    public GlobalTemporaryTableStrategy(TemporaryTable temporaryTable, SessionFactoryImplementor sessionFactory) {
        this.temporaryTable = temporaryTable;
        this.sessionFactory = sessionFactory;
        TemporaryTableStrategy temporaryTableStrategy = GlobalTemporaryTableStrategy.requireGlobalTemporaryTableStrategy(sessionFactory.getJdbcServices().getDialect());
        if (temporaryTableStrategy.getTemporaryTableAfterUseAction() == AfterUseAction.DROP) {
            throw new IllegalArgumentException("Global-temp ID tables cannot use AfterUseAction.DROP : " + temporaryTable.getTableExpression());
        }
    }

    protected static TemporaryTableStrategy requireGlobalTemporaryTableStrategy(Dialect dialect) {
        return Objects.requireNonNull(dialect.getGlobalTemporaryTableStrategy(), "Dialect does not define a global temporary table strategy: " + dialect.getClass().getSimpleName());
    }

    public TemporaryTableStrategy getTemporaryTableStrategy() {
        return NullnessUtil.castNonNull(this.sessionFactory.getJdbcServices().getDialect().getGlobalTemporaryTableStrategy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(MappingModelCreationProcess mappingModelCreationProcess, JdbcConnectionAccess connectionAccess) {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        ConfigurationService configService = mappingModelCreationProcess.getCreationContext().getBootstrapContext().getServiceRegistry().requireService(ConfigurationService.class);
        if (configService.getSetting(CREATE_ID_TABLES, StandardConverters.BOOLEAN, Boolean.valueOf(true)).booleanValue()) {
            Connection connection;
            log.tracef("Creating global-temp ID table: %s", (Object)this.getTemporaryTable().getTableExpression());
            TemporaryTableHelper.TemporaryTableCreationWork temporaryTableCreationWork = new TemporaryTableHelper.TemporaryTableCreationWork(this.getTemporaryTable(), this.sessionFactory);
            try {
                connection = connectionAccess.obtainConnection();
            }
            catch (UnsupportedOperationException e) {
                log.debug("Unable to obtain JDBC connection; assuming ID tables already exist or wont be needed");
                return;
            }
            catch (SQLException e) {
                log.error((Object)"Unable obtain JDBC Connection", e);
                return;
            }
            try {
                temporaryTableCreationWork.execute(connection);
                this.dropIdTables = configService.getSetting(DROP_ID_TABLES, StandardConverters.BOOLEAN, Boolean.valueOf(false));
            }
            finally {
                try {
                    connectionAccess.releaseConnection(connection);
                }
                catch (SQLException exception) {
                    JdbcLogging.JDBC_MESSAGE_LOGGER.unableToReleaseConnection(exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(SessionFactoryImplementor sessionFactory, JdbcConnectionAccess connectionAccess) {
        Connection connection;
        if (!this.dropIdTables) {
            return;
        }
        this.dropIdTables = false;
        log.tracef("Dropping global-temp ID table: %s", (Object)this.getTemporaryTable().getTableExpression());
        TemporaryTableHelper.TemporaryTableDropWork temporaryTableDropWork = new TemporaryTableHelper.TemporaryTableDropWork(this.getTemporaryTable(), sessionFactory);
        try {
            connection = connectionAccess.obtainConnection();
        }
        catch (UnsupportedOperationException e) {
            log.debugf("Unable to obtain JDBC connection; unable to drop global-temp ID table : %s", (Object)this.getTemporaryTable().getTableExpression());
            return;
        }
        catch (SQLException e) {
            log.error((Object)"Unable obtain JDBC Connection", e);
            return;
        }
        try {
            temporaryTableDropWork.execute(connection);
        }
        finally {
            try {
                connectionAccess.releaseConnection(connection);
            }
            catch (SQLException exception) {
                JdbcLogging.JDBC_MESSAGE_LOGGER.unableToReleaseConnection(exception);
            }
        }
    }

    public TemporaryTable getTemporaryTable() {
        return this.temporaryTable;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

