/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results;

import java.lang.invoke.MethodHandles;
import org.hibernate.Internal;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.results.loading", description="Logging related to building parts of the domain model from JDBC or from cache")
@Internal
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=90005801, max=90005900)
public interface LoadingLogger
extends BasicLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.results.loading";
    public static final Logger LOGGER = Logger.getLogger("org.hibernate.orm.results.loading");
    public static final LoadingLogger LOADING_LOGGER = Logger.getMessageLogger(MethodHandles.lookup(), LoadingLogger.class, "org.hibernate.orm.results.loading");
    public static final boolean TRACE_ENABLED = LOGGER.isTraceEnabled();
    public static final boolean DEBUG_ENABLED = LOGGER.isDebugEnabled();

    public static String subLoggerName(String subName) {
        return "org.hibernate.orm.results.loading." + subName;
    }

    public static Logger subLogger(String subName) {
        return Logger.getLogger(LoadingLogger.subLoggerName(subName));
    }

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=90005801, value="Found matching entity in context, but it is scheduled for removal (returning null)")
    public void foundEntityScheduledForRemoval();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=90005802, value="Found matching entity in context, but the matched entity had an inconsistent type")
    public void foundEntityWrongType();
}

