/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import java.util.Arrays;
import java.util.List;
import org.hibernate.internal.util.type.PrimitiveWrapperHelper;
import org.hibernate.sql.results.internal.TupleMetadata;

public class TupleImpl
implements Tuple {
    private final TupleMetadata tupleMetadata;
    private final Object[] row;

    public TupleImpl(TupleMetadata tupleMetadata, Object[] row) {
        this.tupleMetadata = tupleMetadata;
        this.row = row;
    }

    @Override
    public <X> X get(TupleElement<X> tupleElement) {
        Integer index = this.tupleMetadata.get(tupleElement);
        if (index == null) {
            throw new IllegalArgumentException("Requested tuple element did not correspond to element in the result tuple");
        }
        return (X)this.row[index];
    }

    @Override
    public <X> X get(String alias, Class<X> type) {
        Object untyped = this.get(alias);
        if (untyped != null && !this.elementTypeMatches(type, untyped)) {
            throw new IllegalArgumentException(String.format("Requested tuple value [alias=%s, value=%s] cannot be assigned to requested type [%s]", alias, untyped, type.getName()));
        }
        return (X)untyped;
    }

    @Override
    public Object get(String alias) {
        Integer index = this.tupleMetadata.get(alias);
        if (index == null) {
            throw new IllegalArgumentException("Given alias [" + alias + "] did not correspond to an element in the result tuple");
        }
        return this.row[index];
    }

    @Override
    public <X> X get(int i, Class<X> type) {
        Object result = this.get(i);
        if (result != null && !this.elementTypeMatches(type, result)) {
            throw new IllegalArgumentException(String.format("Requested tuple value [index=%s, realType=%s] cannot be assigned to requested type [%s]", i, result.getClass().getName(), type.getName()));
        }
        return (X)result;
    }

    @Override
    public Object get(int i) {
        if (i >= this.row.length) {
            throw new IllegalArgumentException("Given index [" + i + "] was outside the range of result tuple size [" + this.row.length + "] ");
        }
        return this.row[i];
    }

    private <X> boolean elementTypeMatches(Class<X> type, Object untyped) {
        return type.isInstance(untyped) || type.isPrimitive() && PrimitiveWrapperHelper.getDescriptorByPrimitiveType(type).getWrapperClass().isInstance(untyped);
    }

    @Override
    public Object[] toArray() {
        return this.row;
    }

    @Override
    public List<TupleElement<?>> getElements() {
        return this.tupleMetadata.getList();
    }

    public String toString() {
        return Arrays.toString(this.row);
    }
}

