/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Internal;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.ContributableDatabaseObject;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.UserDefinedType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.internal.AbstractSchemaPopulator;
import org.hibernate.tool.schema.internal.DefaultSchemaFilter;
import org.hibernate.tool.schema.internal.ExceptionHandlerHaltImpl;
import org.hibernate.tool.schema.internal.ExceptionHandlerLoggedImpl;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.GenerationTarget;
import org.hibernate.tool.schema.spi.SchemaCreator;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;
import org.hibernate.tool.schema.spi.TargetDescriptor;

public class SchemaCreatorImpl
extends AbstractSchemaPopulator
implements SchemaCreator {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SchemaCreatorImpl.class);
    private final HibernateSchemaManagementTool tool;
    private final SchemaFilter schemaFilter;

    public SchemaCreatorImpl(HibernateSchemaManagementTool tool) {
        this(tool, (SchemaFilter)DefaultSchemaFilter.INSTANCE);
    }

    public SchemaCreatorImpl(HibernateSchemaManagementTool tool, SchemaFilter schemaFilter) {
        this.tool = tool;
        this.schemaFilter = schemaFilter;
    }

    public SchemaCreatorImpl(ServiceRegistry serviceRegistry) {
        this(serviceRegistry, (SchemaFilter)DefaultSchemaFilter.INSTANCE);
    }

    public SchemaCreatorImpl(ServiceRegistry serviceRegistry, SchemaFilter schemaFilter) {
        SchemaManagementTool schemaManagementTool = serviceRegistry.getService(SchemaManagementTool.class);
        if (schemaManagementTool instanceof HibernateSchemaManagementTool) {
            HibernateSchemaManagementTool schemaManagementTool2;
            this.tool = schemaManagementTool2 = (HibernateSchemaManagementTool)schemaManagementTool;
        } else {
            this.tool = new HibernateSchemaManagementTool();
            this.tool.injectServices((ServiceRegistryImplementor)serviceRegistry);
        }
        this.schemaFilter = schemaFilter;
    }

    @Override
    public void doCreation(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, SourceDescriptor sourceDescriptor, TargetDescriptor targetDescriptor) {
        if (!targetDescriptor.getTargetTypes().isEmpty()) {
            Map<String, Object> configuration = options.getConfigurationValues();
            JdbcContext jdbcContext = this.tool.resolveJdbcContext(configuration);
            this.doCreation(metadata, jdbcContext.getDialect(), options, contributableInclusionFilter, sourceDescriptor, this.tool.buildGenerationTargets(targetDescriptor, jdbcContext, configuration, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void doCreation(Metadata metadata, Dialect dialect, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, SourceDescriptor sourceDescriptor, GenerationTarget ... targets) {
        for (GenerationTarget target : targets) {
            target.prepare();
        }
        try {
            this.performCreation(metadata, dialect, options, contributableInclusionFilter, sourceDescriptor, targets);
        }
        finally {
            for (GenerationTarget target : targets) {
                try {
                    target.release();
                }
                catch (Exception e) {
                    log.debugf("Problem releasing GenerationTarget [%s]: %s", (Object)target, (Object)e.getMessage());
                }
            }
        }
    }

    private void performCreation(Metadata metadata, Dialect dialect, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, SourceDescriptor sourceDescriptor, GenerationTarget ... targets) {
        SqlScriptCommandExtractor commandExtractor = this.getCommandExtractor();
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        Formatter formatter = format ? FormatStyle.DDL.getFormatter() : FormatStyle.NONE.getFormatter();
        switch (sourceDescriptor.getSourceType()) {
            case SCRIPT: {
                this.createFromScript(sourceDescriptor.getScriptSourceInput(), commandExtractor, formatter, dialect, options, targets);
                break;
            }
            case METADATA: {
                this.createFromMetadata(metadata, options, contributableInclusionFilter, dialect, formatter, targets);
                break;
            }
            case METADATA_THEN_SCRIPT: {
                this.createFromMetadata(metadata, options, contributableInclusionFilter, dialect, formatter, targets);
                this.createFromScript(sourceDescriptor.getScriptSourceInput(), commandExtractor, formatter, dialect, options, targets);
                break;
            }
            case SCRIPT_THEN_METADATA: {
                this.createFromScript(sourceDescriptor.getScriptSourceInput(), commandExtractor, formatter, dialect, options, targets);
                this.createFromMetadata(metadata, options, contributableInclusionFilter, dialect, formatter, targets);
            }
        }
        this.applyImportSources(options, commandExtractor, format, dialect, targets);
    }

    private SqlScriptCommandExtractor getCommandExtractor() {
        return this.tool.getServiceRegistry().getService(SqlScriptCommandExtractor.class);
    }

    @Override
    ClassLoaderService getClassLoaderService() {
        return this.tool.getServiceRegistry().getService(ClassLoaderService.class);
    }

    public void createFromScript(ScriptSourceInput scriptSourceInput, SqlScriptCommandExtractor commandExtractor, Formatter formatter, Dialect dialect, ExecutionOptions options, GenerationTarget ... targets) {
        Helper.applyScript(options, commandExtractor, dialect, scriptSourceInput, formatter, targets);
    }

    @Internal
    public void createFromMetadata(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, GenerationTarget ... targets) {
        this.createFromMetadata(metadata, options, (ContributableDatabaseObject contributed) -> true, dialect, formatter, targets);
    }

    @Internal
    public void createFromMetadata(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, GenerationTarget ... targets) {
        SqlStringGenerationContext context = Helper.createSqlStringGenerationContext(options, metadata);
        HashSet<String> exportIdentifiers = CollectionHelper.setOfSize(50);
        SchemaCreatorImpl.createSchemasAndCatalogs(metadata, options, this.schemaFilter, dialect, formatter, context, targets);
        SchemaCreatorImpl.createAuxiliaryObjectsBeforeTables(metadata, options, dialect, formatter, context, exportIdentifiers, targets);
        SchemaCreatorImpl.createUserDefinedTypes(metadata, options, this.schemaFilter, dialect, formatter, context, targets);
        SchemaCreatorImpl.createSequencesTablesConstraints(metadata, options, this.schemaFilter, contributableInclusionMatcher, dialect, formatter, context, exportIdentifiers, targets);
        SchemaCreatorImpl.createForeignKeys(metadata, options, this.schemaFilter, contributableInclusionMatcher, dialect, formatter, context, targets);
        SchemaCreatorImpl.createAuxiliaryObjectsAfterTables(metadata, options, dialect, formatter, context, exportIdentifiers, targets);
        SchemaCreatorImpl.executeInitCommands(metadata, options, formatter, targets);
    }

    private static void executeInitCommands(Metadata metadata, ExecutionOptions options, Formatter formatter, GenerationTarget[] targets) {
        for (InitCommand initCommand : metadata.getDatabase().getInitCommands()) {
            Helper.applySqlStrings(initCommand.initCommands(), formatter, options, targets);
        }
    }

    private static void createAuxiliaryObjectsAfterTables(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets) {
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : metadata.getDatabase().getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect) || auxiliaryDatabaseObject.beforeTablesOnCreation()) continue;
            SchemaCreatorImpl.checkExportIdentifier(auxiliaryDatabaseObject, exportIdentifiers);
            Helper.applySqlStrings(dialect.getAuxiliaryDatabaseObjectExporter().getSqlCreateStrings(auxiliaryDatabaseObject, metadata, context), formatter, options, targets);
        }
    }

    private static void createForeignKeys(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
            if (!schemaFilter.includeNamespace(namespace)) continue;
            for (Table table : namespace.getTables()) {
                if (!schemaFilter.includeTable(table) || !contributableInclusionMatcher.matches(table)) continue;
                for (ForeignKey foreignKey : table.getForeignKeyCollection()) {
                    Helper.applySqlStrings(dialect.getForeignKeyExporter().getSqlCreateStrings(foreignKey, metadata, context), formatter, options, targets);
                }
            }
        }
    }

    private static void createSequencesTablesConstraints(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets) {
        for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
            if (!schemaFilter.includeNamespace(namespace)) continue;
            SchemaCreatorImpl.createSequences(metadata, options, schemaFilter, contributableInclusionMatcher, dialect, formatter, context, exportIdentifiers, targets, namespace);
            SchemaCreatorImpl.createTables(metadata, options, schemaFilter, contributableInclusionMatcher, dialect, formatter, context, exportIdentifiers, targets, namespace);
            SchemaCreatorImpl.createTableConstraints(metadata, options, schemaFilter, contributableInclusionMatcher, dialect, formatter, context, exportIdentifiers, targets, namespace);
        }
    }

    private static void createTableConstraints(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets, Namespace namespace) {
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || !schemaFilter.includeTable(table) || !contributableInclusionMatcher.matches(table)) continue;
            for (Index index : table.getIndexes().values()) {
                SchemaCreatorImpl.checkExportIdentifier(index, exportIdentifiers);
                Helper.applySqlStrings(dialect.getIndexExporter().getSqlCreateStrings(index, metadata, context), formatter, options, targets);
            }
            for (UniqueKey uniqueKey : table.getUniqueKeys().values()) {
                SchemaCreatorImpl.checkExportIdentifier(uniqueKey, exportIdentifiers);
                Helper.applySqlStrings(dialect.getUniqueKeyExporter().getSqlCreateStrings(uniqueKey, metadata, context), formatter, options, targets);
            }
        }
    }

    private static void createTables(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets, Namespace namespace) {
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || table.isView() || !schemaFilter.includeTable(table) || !contributableInclusionMatcher.matches(table)) continue;
            SchemaCreatorImpl.checkExportIdentifier(table, exportIdentifiers);
            Helper.applySqlStrings(dialect.getTableExporter().getSqlCreateStrings(table, metadata, context), formatter, options, targets);
        }
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || !table.isView() || !schemaFilter.includeTable(table) || !contributableInclusionMatcher.matches(table)) continue;
            SchemaCreatorImpl.checkExportIdentifier(table, exportIdentifiers);
            Helper.applySqlStrings(dialect.getTableExporter().getSqlCreateStrings(table, metadata, context), formatter, options, targets);
        }
    }

    private static void createSequences(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, ContributableMatcher contributableInclusionMatcher, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets, Namespace namespace) {
        for (Sequence sequence : namespace.getSequences()) {
            if (!schemaFilter.includeSequence(sequence) || !contributableInclusionMatcher.matches(sequence)) continue;
            SchemaCreatorImpl.checkExportIdentifier(sequence, exportIdentifiers);
            Helper.applySqlStrings(dialect.getSequenceExporter().getSqlCreateStrings(sequence, metadata, context), formatter, options, targets);
        }
    }

    private static void createAuxiliaryObjectsBeforeTables(Metadata metadata, ExecutionOptions options, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, Set<String> exportIdentifiers, GenerationTarget[] targets) {
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : metadata.getDatabase().getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaCreatorImpl.checkExportIdentifier(auxiliaryDatabaseObject, exportIdentifiers);
            Helper.applySqlStrings(dialect.getAuxiliaryDatabaseObjectExporter().getSqlCreateStrings(auxiliaryDatabaseObject, metadata, context), formatter, options, targets);
        }
    }

    static void createUserDefinedTypes(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
            if (!schemaFilter.includeNamespace(namespace)) continue;
            for (UserDefinedType userDefinedType : namespace.getDependencyOrderedUserDefinedTypes()) {
                Helper.applySqlStrings(dialect.getUserDefinedTypeExporter().getSqlCreateStrings(userDefinedType, metadata, context), formatter, options, targets);
            }
        }
    }

    private static void createSchemasAndCatalogs(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, Dialect dialect, Formatter formatter, SqlStringGenerationContext context, GenerationTarget[] targets) {
        boolean tryToCreateSchemas;
        boolean tryToCreateCatalogs = options.shouldManageNamespaces() && dialect.canCreateCatalog();
        boolean bl = tryToCreateSchemas = options.shouldManageNamespaces() && dialect.canCreateSchema();
        if (tryToCreateCatalogs || tryToCreateSchemas) {
            HashSet<Identifier> exportedCatalogs = new HashSet<Identifier>();
            for (Namespace namespace : metadata.getDatabase().getNamespaces()) {
                Identifier schemaPhysicalName;
                if (!schemaFilter.includeNamespace(namespace)) continue;
                Namespace.Name logicalName = namespace.getName();
                Namespace.Name physicalName = namespace.getPhysicalName();
                if (tryToCreateCatalogs) {
                    Identifier catalogLogicalName = logicalName.catalog();
                    Identifier catalogPhysicalName = context.catalogWithDefault(physicalName.catalog());
                    if (catalogPhysicalName != null && !exportedCatalogs.contains(catalogLogicalName)) {
                        Helper.applySqlStrings(dialect.getCreateCatalogCommand(catalogPhysicalName.render(dialect)), formatter, options, targets);
                        exportedCatalogs.add(catalogLogicalName);
                    }
                }
                if (!tryToCreateSchemas || (schemaPhysicalName = context.schemaWithDefault(physicalName.schema())) == null) continue;
                Helper.applySqlStrings(dialect.getCreateSchemaCommand(schemaPhysicalName.render(dialect)), formatter, options, targets);
            }
        }
    }

    private static void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException("SQL strings added more than once for: " + exportIdentifier);
        }
        exportIdentifiers.add(exportIdentifier);
    }

    public List<String> generateCreationCommands(Metadata metadata, final boolean manageNamespaces) {
        JournalingGenerationTarget target = new JournalingGenerationTarget();
        MetadataImplementor metadataImplementor = (MetadataImplementor)metadata;
        Dialect dialect = metadataImplementor.getMetadataBuildingOptions().getServiceRegistry().requireService(JdbcEnvironment.class).getDialect();
        ExecutionOptions options = new ExecutionOptions(){

            @Override
            public boolean shouldManageNamespaces() {
                return manageNamespaces;
            }

            @Override
            public Map<String, Object> getConfigurationValues() {
                return Collections.emptyMap();
            }

            @Override
            public ExceptionHandler getExceptionHandler() {
                return ExceptionHandlerHaltImpl.INSTANCE;
            }
        };
        this.createFromMetadata(metadata, options, dialect, FormatStyle.NONE.getFormatter(), target);
        return target.commands;
    }

    @Internal
    public void doCreation(Metadata metadata, boolean manageNamespaces, GenerationTarget ... targets) {
        StandardServiceRegistry serviceRegistry = ((MetadataImplementor)metadata).getMetadataBuildingOptions().getServiceRegistry();
        this.doCreation(metadata, serviceRegistry, serviceRegistry.requireService(ConfigurationService.class).getSettings(), manageNamespaces, targets);
    }

    @Internal
    public void doCreation(Metadata metadata, ServiceRegistry serviceRegistry, final Map<String, Object> settings, final boolean manageNamespaces, GenerationTarget ... targets) {
        this.doCreation(metadata, serviceRegistry.requireService(JdbcEnvironment.class).getDialect(), new ExecutionOptions(){

            @Override
            public boolean shouldManageNamespaces() {
                return manageNamespaces;
            }

            @Override
            public Map<String, Object> getConfigurationValues() {
                return settings;
            }

            @Override
            public ExceptionHandler getExceptionHandler() {
                return ExceptionHandlerLoggedImpl.INSTANCE;
            }
        }, (ContributableDatabaseObject contributed) -> true, new SourceDescriptor(){

            @Override
            public SourceType getSourceType() {
                return SourceType.METADATA;
            }

            @Override
            public ScriptSourceInput getScriptSourceInput() {
                return null;
            }
        }, targets);
    }

    private static class JournalingGenerationTarget
    implements GenerationTarget {
        private final ArrayList<String> commands = new ArrayList();

        private JournalingGenerationTarget() {
        }

        @Override
        public void prepare() {
        }

        @Override
        public void accept(String command) {
            this.commands.add(command);
        }

        @Override
        public void release() {
        }
    }
}

