/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.PersistenceException;
import java.util.Objects;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.converter.internal.AttributeConverterMutabilityPlan;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.java.spi.RegistryHelper;

public final class AttributeConverterBean<O, R>
implements JpaAttributeConverter<O, R> {
    private final ManagedBean<? extends AttributeConverter<O, R>> attributeConverterBean;
    private final JavaType<? extends AttributeConverter<O, R>> converterJavaType;
    private final JavaType<O> domainJavaType;
    private final JavaType<R> jdbcJavaType;

    public AttributeConverterBean(ManagedBean<? extends AttributeConverter<O, R>> attributeConverterBean, JavaType<? extends AttributeConverter<O, R>> converterJavaType, JavaType<O> domainJavaType, JavaType<R> jdbcJavaType) {
        this.attributeConverterBean = attributeConverterBean;
        this.converterJavaType = converterJavaType;
        this.domainJavaType = domainJavaType;
        this.jdbcJavaType = jdbcJavaType;
    }

    public AttributeConverterBean(ManagedBean<? extends AttributeConverter<O, R>> attributeConverterBean, JavaType<? extends AttributeConverter<O, R>> converterJavaType, Class<O> domainJavaType, Class<R> jdbcJavaType, JpaAttributeConverterCreationContext context) {
        this.attributeConverterBean = attributeConverterBean;
        this.converterJavaType = converterJavaType;
        JavaTypeRegistry jtdRegistry = context.getJavaTypeRegistry();
        this.jdbcJavaType = jtdRegistry.getDescriptor(jdbcJavaType);
        this.domainJavaType = jtdRegistry.resolveDescriptor(domainJavaType, () -> this.getTypeDescriptor(attributeConverterBean, domainJavaType, context));
    }

    private JavaType<O> getTypeDescriptor(ManagedBean<? extends AttributeConverter<O, R>> attributeConverterBean, Class<O> domainJavaType, JpaAttributeConverterCreationContext context) {
        return RegistryHelper.INSTANCE.createTypeDescriptor(domainJavaType, () -> this.getMutabilityPlan(attributeConverterBean, context), context.getTypeConfiguration());
    }

    private MutabilityPlan<O> getMutabilityPlan(ManagedBean<? extends AttributeConverter<O, R>> attributeConverterBean, JpaAttributeConverterCreationContext context) {
        AttributeConverterMutabilityPlan mutabilityPlan = RegistryHelper.INSTANCE.determineMutabilityPlan(attributeConverterBean.getBeanClass(), context.getTypeConfiguration());
        return mutabilityPlan == null ? new AttributeConverterMutabilityPlan(this, true) : mutabilityPlan;
    }

    @Override
    public ManagedBean<? extends AttributeConverter<O, R>> getConverterBean() {
        return this.attributeConverterBean;
    }

    @Override
    public O toDomainValue(R relationalForm) {
        try {
            return this.attributeConverterBean.getBeanInstance().convertToEntityAttribute(relationalForm);
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (RuntimeException re) {
            throw new PersistenceException("Error attempting to apply AttributeConverter", re);
        }
    }

    @Override
    public R toRelationalValue(O domainForm) {
        try {
            return this.attributeConverterBean.getBeanInstance().convertToDatabaseColumn(domainForm);
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (RuntimeException re) {
            throw new PersistenceException("Error attempting to apply AttributeConverter: " + re.getMessage(), re);
        }
    }

    @Override
    public JavaType<? extends AttributeConverter<O, R>> getConverterJavaType() {
        return this.converterJavaType;
    }

    @Override
    public JavaType<O> getDomainJavaType() {
        return this.domainJavaType;
    }

    @Override
    public JavaType<R> getRelationalJavaType() {
        return this.jdbcJavaType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AttributeConverterBean)) return false;
        AttributeConverterBean that = (AttributeConverterBean)object;
        if (!Objects.equals(this.attributeConverterBean, that.attributeConverterBean)) return false;
        if (!Objects.equals(this.converterJavaType, that.converterJavaType)) return false;
        if (!Objects.equals(this.domainJavaType, that.domainJavaType)) return false;
        if (!Objects.equals(this.jdbcJavaType, that.jdbcJavaType)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.attributeConverterBean, this.converterJavaType, this.domainJavaType, this.jdbcJavaType);
    }
}

