/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.progwml6.ironchest.client.IronChestsClientRegistration;
import com.progwml6.ironchest.client.model.IronChestModel;
import com.progwml6.ironchest.client.model.ModelItem;
import com.progwml6.ironchest.client.renderer.IronChestsModels;
import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.block.entity.ICrystalChest;
import com.progwml6.ironchest.common.block.regular.AbstractIronChestBlock;
import com.progwml6.ironchest.common.block.regular.entity.AbstractIronChestBlockEntity;
import com.progwml6.ironchest.common.block.trapped.entity.AbstractTrappedIronChestBlockEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class IronChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final IronChestModel model;
    private final BlockEntityRenderDispatcher renderer;
    private static final List<ModelItem> MODEL_ITEMS = Arrays.asList(new ModelItem(new Vector3f(0.3f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.5f, 0.32f, 0.5f), 3.0f));

    public IronChestRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.getBlockEntityRenderDispatcher();
        this.model = new IronChestModel(context.bakeLayer(IronChestsClientRegistration.IRON_CHEST));
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 p_401038_) {
        AbstractIronChestBlockEntity chestBlockEntity = (AbstractIronChestBlockEntity)((Object)blockEntity);
        Level level = chestBlockEntity.getLevel();
        boolean useTileEntityBlockState = level != null;
        BlockState blockState = useTileEntityBlockState ? chestBlockEntity.getBlockState() : (BlockState)chestBlockEntity.getBlockToUse().defaultBlockState().setValue(AbstractIronChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = blockState.getBlock();
        IronChestsTypes chestType = IronChestsTypes.IRON;
        IronChestsTypes actualType = AbstractIronChestBlock.getTypeFromBlock(block);
        if (actualType != null) {
            chestType = actualType;
        }
        if (block instanceof AbstractIronChestBlock) {
            poseStack.pushPose();
            float f = ((Direction)blockState.getValue(AbstractIronChestBlock.FACING)).toYRot();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-f));
            poseStack.translate(-0.5, -0.5, -0.5);
            float openness = chestBlockEntity.getOpenNess(partialTick);
            openness = 1.0f - openness;
            openness = 1.0f - openness * openness * openness;
            boolean trapped = blockEntity instanceof AbstractTrappedIronChestBlockEntity;
            Material material = IronChestsModels.chooseChestMaterial(chestType, trapped);
            VertexConsumer vertexConsumer = material.buffer(bufferSource, RenderType::entityCutout);
            this.render(poseStack, vertexConsumer, this.model, openness, packedLight, packedOverlay);
            poseStack.popPose();
            if (chestType.isTransparent() && chestBlockEntity instanceof ICrystalChest) {
                ICrystalChest crystalChest = (ICrystalChest)((Object)chestBlockEntity);
                if (Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos()).closerThan((Position)this.renderer.camera.getPosition(), 128.0)) {
                    float rotation = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTick;
                    for (int j = 0; j < MODEL_ITEMS.size() - 1; ++j) {
                        IronChestRenderer.renderItem(poseStack, bufferSource, (ItemStack)crystalChest.getTopItems().get(j), MODEL_ITEMS.get(j), rotation, packedLight);
                    }
                }
            }
        }
    }

    private void render(PoseStack poseStack, VertexConsumer buffer, IronChestModel model, float openness, int packedLight, int packedOverlay) {
        model.setupAnim(openness);
        model.renderToBuffer(poseStack, buffer, packedLight, packedOverlay);
    }

    public static void renderItem(PoseStack matrices, MultiBufferSource buffer, ItemStack item, ModelItem modelItem, float rotation, int light) {
        if (item.isEmpty()) {
            return;
        }
        matrices.pushPose();
        Vector3f center = modelItem.getCenter();
        matrices.translate(center.x(), center.y(), center.z());
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
        float scale = modelItem.getSizeScaled();
        matrices.scale(scale, scale, scale);
        Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.NONE, light, OverlayTexture.NO_OVERLAY, matrices, buffer, null, 0);
        matrices.popPose();
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 1, 1));
    }
}

