/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.progwml6.ironchest.IronChests;
import com.progwml6.ironchest.client.IronChestsClientRegistration;
import com.progwml6.ironchest.client.model.IronChestModel;
import java.util.Set;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class IronChestSpecialRenderer
implements NoDataSpecialModelRenderer {
    public static final ResourceLocation IRON_CHEST_TEXTURE = IronChests.prefix("model/iron_chest");
    public static final ResourceLocation TRAPPED_IRON_CHEST_TEXTURE = IronChests.prefix("model/trapped_iron_chest");
    public static final ResourceLocation GOLD_CHEST_TEXTURE = IronChests.prefix("model/gold_chest");
    public static final ResourceLocation TRAPPED_GOLD_CHEST_TEXTURE = IronChests.prefix("model/trapped_gold_chest");
    public static final ResourceLocation DIAMOND_CHEST_TEXTURE = IronChests.prefix("model/diamond_chest");
    public static final ResourceLocation TRAPPED_DIAMOND_CHEST_TEXTURE = IronChests.prefix("model/trapped_diamond_chest");
    public static final ResourceLocation COPPER_CHEST_TEXTURE = IronChests.prefix("model/copper_chest");
    public static final ResourceLocation TRAPPED_COPPER_CHEST_TEXTURE = IronChests.prefix("model/trapped_copper_chest");
    public static final ResourceLocation CRYSTAL_CHEST_TEXTURE = IronChests.prefix("model/crystal_chest");
    public static final ResourceLocation TRAPPED_CRYSTAL_CHEST_TEXTURE = IronChests.prefix("model/trapped_crystal_chest");
    public static final ResourceLocation OBSIDIAN_CHEST_TEXTURE = IronChests.prefix("model/obsidian_chest");
    public static final ResourceLocation TRAPPED_OBSIDIAN_CHEST_TEXTURE = IronChests.prefix("model/trapped_obsidian_chest");
    public static final ResourceLocation DIRT_CHEST_TEXTURE = IronChests.prefix("model/dirt_chest");
    public static final ResourceLocation TRAPPED_DIRT_CHEST_TEXTURE = IronChests.prefix("model/trapped_dirt_chest");
    private final IronChestModel model;
    private final Material material;
    private final float openness;

    public IronChestSpecialRenderer(IronChestModel model, Material material, float openness) {
        this.model = model;
        this.material = material;
        this.openness = openness;
    }

    public void render(ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        VertexConsumer vertexconsumer = this.material.buffer(bufferSource, RenderType::entityCutout);
        this.model.setupAnim(this.openness);
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, packedOverlay);
    }

    public void getExtents(Set<Vector3f> output) {
        PoseStack posestack = new PoseStack();
        this.model.setupAnim(this.openness);
        this.model.root().getExtentsForGui(posestack, output);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(ResourceLocation texture, float openness) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(unbakedInstance -> unbakedInstance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Unbaked::texture), (App)Codec.FLOAT.optionalFieldOf("openness", (Object)Float.valueOf(0.0f)).forGetter(Unbaked::openness)).apply((Applicative)unbakedInstance, Unbaked::new));

        public Unbaked(ResourceLocation resourceLocation) {
            this(resourceLocation, 0.0f);
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet entityModelSet) {
            IronChestModel chestModel = new IronChestModel(entityModelSet.bakeLayer(IronChestsClientRegistration.IRON_CHEST));
            Material material = new Material(Sheets.CHEST_SHEET, this.texture);
            return new IronChestSpecialRenderer(chestModel, material, this.openness);
        }
    }
}

