/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.data;

import com.progwml6.ironchest.IronChests;
import com.progwml6.ironchest.client.renderer.special.IronChestSpecialRenderer;
import com.progwml6.ironchest.common.block.IronChestsBlocks;
import com.progwml6.ironchest.common.item.IronChestsItems;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class IronChestsModelProvider
extends ModelProvider {
    public IronChestsModelProvider(PackOutput output) {
        super(output, "ironchest");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.IRON_CHEST.get(), IronChests.prefix("block/iron_break"), IronChestSpecialRenderer.IRON_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.TRAPPED_IRON_CHEST.get(), IronChests.prefix("block/iron_break"), IronChestSpecialRenderer.TRAPPED_IRON_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.GOLD_CHEST.get(), IronChests.prefix("block/gold_break"), IronChestSpecialRenderer.GOLD_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.TRAPPED_GOLD_CHEST.get(), IronChests.prefix("block/gold_break"), IronChestSpecialRenderer.TRAPPED_GOLD_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.DIAMOND_CHEST.get(), IronChests.prefix("block/diamond_break"), IronChestSpecialRenderer.DIAMOND_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.TRAPPED_DIAMOND_CHEST.get(), IronChests.prefix("block/diamond_break"), IronChestSpecialRenderer.TRAPPED_DIAMOND_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.COPPER_CHEST.get(), IronChests.prefix("block/copper_break"), IronChestSpecialRenderer.COPPER_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.TRAPPED_COPPER_CHEST.get(), IronChests.prefix("block/copper_break"), IronChestSpecialRenderer.TRAPPED_COPPER_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.CRYSTAL_CHEST.get(), IronChests.prefix("block/crystal_break"), IronChestSpecialRenderer.CRYSTAL_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.TRAPPED_CRYSTAL_CHEST.get(), IronChests.prefix("block/crystal_break"), IronChestSpecialRenderer.TRAPPED_CRYSTAL_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.OBSIDIAN_CHEST.get(), TextureMapping.getBlockTexture((Block)Blocks.OBSIDIAN), IronChestSpecialRenderer.OBSIDIAN_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.TRAPPED_OBSIDIAN_CHEST.get(), TextureMapping.getBlockTexture((Block)Blocks.OBSIDIAN), IronChestSpecialRenderer.TRAPPED_OBSIDIAN_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.DIRT_CHEST.get(), TextureMapping.getBlockTexture((Block)Blocks.DIRT), IronChestSpecialRenderer.DIRT_CHEST_TEXTURE);
        this.createChest(blockModels, itemModels, (Block)IronChestsBlocks.TRAPPED_DIRT_CHEST.get(), TextureMapping.getBlockTexture((Block)Blocks.DIRT), IronChestSpecialRenderer.TRAPPED_DIRT_CHEST_TEXTURE);
        this.generateFlatItem(itemModels, (Item)IronChestsItems.IRON_TO_GOLD_CHEST_UPGRADE.get(), IronChests.prefix("item/iron_gold_upgrade"));
        this.generateFlatItem(itemModels, (Item)IronChestsItems.GOLD_TO_DIAMOND_CHEST_UPGRADE.get(), IronChests.prefix("item/gold_diamond_upgrade"));
        this.generateFlatItem(itemModels, (Item)IronChestsItems.COPPER_TO_IRON_CHEST_UPGRADE.get(), IronChests.prefix("item/copper_iron_upgrade"));
        this.generateFlatItem(itemModels, (Item)IronChestsItems.DIAMOND_TO_CRYSTAL_CHEST_UPGRADE.get(), IronChests.prefix("item/diamond_crystal_upgrade"));
        this.generateFlatItem(itemModels, (Item)IronChestsItems.WOOD_TO_IRON_CHEST_UPGRADE.get(), IronChests.prefix("item/wood_iron_upgrade"));
        this.generateFlatItem(itemModels, (Item)IronChestsItems.WOOD_TO_COPPER_CHEST_UPGRADE.get(), IronChests.prefix("item/wood_copper_upgrade"));
        this.generateFlatItem(itemModels, (Item)IronChestsItems.DIAMOND_TO_OBSIDIAN_CHEST_UPGRADE.get(), IronChests.prefix("item/diamond_obsidian_upgrade"));
    }

    public void createChest(BlockModelGenerators blockModels, ItemModelGenerators itemModels, Block chestBlock, ResourceLocation particleTexture, ResourceLocation texture) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)chestBlock, (MultiVariant)new MultiVariant(WeightedList.of((Object)new Variant(ModelTemplates.PARTICLE_ONLY.create(chestBlock, TextureMapping.particle((ResourceLocation)particleTexture), blockModels.modelOutput))))));
        Item chestItem = chestBlock.asItem();
        ResourceLocation resourceLocation = ModelTemplates.CHEST_INVENTORY.create(chestItem, TextureMapping.particle((ResourceLocation)particleTexture), blockModels.modelOutput);
        ItemModel.Unbaked unbaked = ItemModelUtils.specialModel((ResourceLocation)resourceLocation, (SpecialModelRenderer.Unbaked)new IronChestSpecialRenderer.Unbaked(texture));
        itemModels.itemModelOutput.accept(chestItem, unbaked);
    }

    public void generateFlatItem(ItemModelGenerators itemModels, Item item, ResourceLocation itemTexture) {
        itemModels.itemModelOutput.accept(item, ItemModelUtils.plainModel((ResourceLocation)ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((ResourceLocation)itemTexture), itemModels.modelOutput)));
    }
}

