/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest;

import com.progwml6.ironchest.common.block.IronChestsBlocks;
import com.progwml6.ironchest.common.block.entity.IronChestsBlockEntityTypes;
import com.progwml6.ironchest.common.block.regular.entity.AbstractIronChestBlockEntity;
import com.progwml6.ironchest.common.creativetabs.IronChestsCreativeTabs;
import com.progwml6.ironchest.common.data.IronChestsBlockTags;
import com.progwml6.ironchest.common.data.IronChestsLanguageProvider;
import com.progwml6.ironchest.common.data.IronChestsModelProvider;
import com.progwml6.ironchest.common.data.IronChestsRecipeProvider;
import com.progwml6.ironchest.common.data.IronChestsSpriteSourceProvider;
import com.progwml6.ironchest.common.data.loot.IronChestsLootTableProvider;
import com.progwml6.ironchest.common.datacomponents.IronChestsDataComponents;
import com.progwml6.ironchest.common.inventory.IronChestsMenuTypes;
import com.progwml6.ironchest.common.item.IronChestsItems;
import com.progwml6.ironchest.common.network.TopStacksSyncPacket;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;

@Mod(value="ironchest")
public class IronChests {
    public static final String MODID = "ironchest";

    public IronChests(IEventBus modEventBus) {
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::setupPackets);
        modEventBus.addListener(this::registerCapabilities);
        IronChestsBlocks.BLOCKS.register(modEventBus);
        IronChestsItems.ITEMS.register(modEventBus);
        IronChestsBlockEntityTypes.BLOCK_ENTITIES.register(modEventBus);
        IronChestsMenuTypes.CONTAINERS.register(modEventBus);
        IronChestsCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        IronChestsDataComponents.COMPONENTS.register(modEventBus);
    }

    public void gatherData(GatherDataEvent.Client event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(true, (DataProvider)new IronChestsLootTableProvider(packOutput, lookupProvider));
        gen.addProvider(true, (DataProvider)new IronChestsRecipeProvider.Runner(packOutput, lookupProvider));
        gen.addProvider(true, (DataProvider)new IronChestsBlockTags(packOutput, lookupProvider));
        gen.addProvider(true, (DataProvider)new IronChestsSpriteSourceProvider(packOutput, lookupProvider));
        gen.addProvider(true, (DataProvider)new IronChestsLanguageProvider(packOutput, "en_us"));
        gen.addProvider(true, (DataProvider)new IronChestsModelProvider(packOutput));
        gen.addProvider(true, (DataProvider)new PackMetadataGenerator(packOutput).add(PackMetadataSection.SERVER_TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)"Resources for Iron Chests"), new InclusiveRange((Comparable)DetectedVersion.BUILT_IN.packVersion(PackType.SERVER_DATA)))));
    }

    public void setupPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.playBidirectional(TopStacksSyncPacket.TYPE, TopStacksSyncPacket.STREAM_CODEC, TopStacksSyncPacket::handleServer);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.Item.BLOCK, (level, pos, state, blockEntity, side) -> {
            ResourceHandler resourceHandler;
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof AbstractIronChestBlockEntity) {
                AbstractIronChestBlockEntity ironChestBlockEntity = (AbstractIronChestBlockEntity)patt0$temp;
                resourceHandler = VanillaContainerWrapper.of((Container)ironChestBlockEntity);
            } else {
                resourceHandler = null;
            }
            return resourceHandler;
        }, new Block[]{(Block)IronChestsBlocks.IRON_CHEST.get(), (Block)IronChestsBlocks.TRAPPED_IRON_CHEST.get(), (Block)IronChestsBlocks.GOLD_CHEST.get(), (Block)IronChestsBlocks.TRAPPED_GOLD_CHEST.get(), (Block)IronChestsBlocks.DIAMOND_CHEST.get(), (Block)IronChestsBlocks.TRAPPED_DIAMOND_CHEST.get(), (Block)IronChestsBlocks.COPPER_CHEST.get(), (Block)IronChestsBlocks.TRAPPED_COPPER_CHEST.get(), (Block)IronChestsBlocks.CRYSTAL_CHEST.get(), (Block)IronChestsBlocks.TRAPPED_CRYSTAL_CHEST.get(), (Block)IronChestsBlocks.OBSIDIAN_CHEST.get(), (Block)IronChestsBlocks.TRAPPED_OBSIDIAN_CHEST.get(), (Block)IronChestsBlocks.DIRT_CHEST.get()});
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }
}

