/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.progwml6.ironchest.client.IronChestsClientRegistration;
import com.progwml6.ironchest.client.model.IronChestModel;
import com.progwml6.ironchest.client.model.ModelItem;
import com.progwml6.ironchest.client.renderer.IronChestRenderState;
import com.progwml6.ironchest.client.renderer.IronChestsModels;
import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.block.entity.ICrystalChest;
import com.progwml6.ironchest.common.block.regular.AbstractIronChestBlock;
import com.progwml6.ironchest.common.block.regular.entity.AbstractIronChestBlockEntity;
import com.progwml6.ironchest.common.block.trapped.entity.AbstractTrappedIronChestBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class IronChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T, IronChestRenderState> {
    private final MaterialSet materials;
    private final IronChestModel model;
    private final ItemModelResolver itemModelResolver;
    private static final List<ModelItem> MODEL_ITEMS = Arrays.asList(new ModelItem(new Vector3f(0.3f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.5f, 0.32f, 0.5f), 3.0f));

    public IronChestRenderer(BlockEntityRendererProvider.Context context) {
        this.materials = context.materials();
        this.itemModelResolver = context.itemModelResolver();
        this.model = new IronChestModel(context.bakeLayer(IronChestsClientRegistration.IRON_CHEST));
    }

    public IronChestRenderState createRenderState() {
        return new IronChestRenderState();
    }

    public void extractRenderState(T blockEntity, IronChestRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        AbstractIronChestBlockEntity chestBlockEntity = (AbstractIronChestBlockEntity)((Object)blockEntity);
        boolean useBlockState = blockEntity.getLevel() != null;
        BlockState blockState = useBlockState ? chestBlockEntity.getBlockState() : (BlockState)chestBlockEntity.getBlockToUse().defaultBlockState().setValue(AbstractIronChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = blockState.getBlock();
        IronChestsTypes chestType = IronChestsTypes.IRON;
        IronChestsTypes actualType = AbstractIronChestBlock.getTypeFromBlock(block);
        if (actualType != null) {
            chestType = actualType;
        }
        renderState.chestType = chestType;
        renderState.open = chestBlockEntity.getOpenNess(partialTick);
        renderState.angle = ((Direction)blockState.getValue(AbstractIronChestBlock.FACING)).toYRot();
        renderState.trapped = blockEntity instanceof AbstractTrappedIronChestBlockEntity;
        renderState.items = new ArrayList<ItemStackRenderState>();
        renderState.itemRotation = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTick;
        int i = (int)blockEntity.getBlockPos().asLong();
        if (chestType.isTransparent() && chestBlockEntity instanceof ICrystalChest) {
            ICrystalChest crystalChest = (ICrystalChest)((Object)chestBlockEntity);
            for (int j = 0; j < MODEL_ITEMS.size() - 1; ++j) {
                ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
                this.itemModelResolver.updateForTopItem(itemStackRenderState, (ItemStack)crystalChest.getTopItems().get(j), ItemDisplayContext.NONE, blockEntity.getLevel(), null, i + j);
                renderState.items.add(itemStackRenderState);
            }
        }
    }

    public void submit(IronChestRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.angle));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        float f = renderState.open;
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        Material material = IronChestsModels.chooseChestMaterial(renderState.chestType, renderState.trapped);
        RenderType renderType = material.renderType(RenderType::entityCutout);
        TextureAtlasSprite textureatlassprite = this.materials.get(material);
        nodeCollector.submitModel((Model)this.model, (Object)Float.valueOf(f), poseStack, renderType, renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, textureatlassprite, 0, renderState.breakProgress);
        poseStack.popPose();
        if (renderState.chestType.isTransparent() && Vec3.atCenterOf((Vec3i)renderState.blockPos).closerThan((Position)cameraRenderState.pos, 128.0)) {
            for (int i = 0; i < renderState.items.size(); ++i) {
                ItemStackRenderState itemStackRenderState = renderState.items.get(i);
                if (itemStackRenderState.isEmpty()) continue;
                ModelItem modelItem = MODEL_ITEMS.get(i);
                Vector3f center = modelItem.getCenter();
                float scale = modelItem.getSizeScaled();
                poseStack.pushPose();
                poseStack.translate(center.x(), center.y(), center.z());
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.itemRotation));
                poseStack.scale(scale, scale, scale);
                itemStackRenderState.submit(poseStack, nodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                poseStack.popPose();
            }
        }
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 1, 1));
    }
}

