/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.block.entity;

import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.network.TopStacksSyncPacket;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public interface ICrystalChest {
    default public NonNullList<ItemStack> buildItemStackDataList() {
        if (this.getChestType().isTransparent()) {
            NonNullList sortList = NonNullList.withSize((int)this.getTopItems().size(), (Object)ItemStack.EMPTY);
            int pos = 0;
            for (ItemStack is : this.getTopItems()) {
                if (!is.isEmpty()) {
                    sortList.set(pos, (Object)is);
                } else {
                    sortList.set(pos, (Object)ItemStack.EMPTY);
                }
                ++pos;
            }
            return sortList;
        }
        return NonNullList.withSize((int)this.getTopItems().size(), (Object)ItemStack.EMPTY);
    }

    public IronChestsTypes getChestType();

    default public void sendTopStacksPacket() {
        Level level;
        NonNullList<ItemStack> stacks = this.buildItemStackDataList();
        if (this.getChestLevel() != null && (level = this.getChestLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.getChestLevel().isClientSide()) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)serverLevel.getChunkAt(this.getChestWorldPosition()).getPos(), (CustomPacketPayload)new TopStacksSyncPacket(this.getChestWorldPosition(), stacks), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public NonNullList<ItemStack> getTopItems();

    @Nullable
    public Level getChestLevel();

    public BlockPos getChestWorldPosition();

    public void receiveMessageFromServer(NonNullList<ItemStack> var1);

    default public void sortTopStacks() {
        int i;
        if (!this.getChestType().isTransparent() || this.getChestLevel() != null && this.getChestLevel().isClientSide()) {
            return;
        }
        NonNullList tempCopy = NonNullList.withSize((int)IronChestsTypes.CRYSTAL.size, (Object)ItemStack.EMPTY);
        boolean hasStuff = false;
        int compressedIdx = 0;
        block0: for (i = 0; i < IronChestsTypes.CRYSTAL.size; ++i) {
            ItemStack itemStack = (ItemStack)this.getCurrentItems().get(i);
            if (itemStack.isEmpty()) continue;
            for (int j = 0; j < compressedIdx; ++j) {
                ItemStack tempCopyStack = (ItemStack)tempCopy.get(j);
                if (!ItemStack.isSameItemSameComponents((ItemStack)tempCopyStack, (ItemStack)itemStack)) continue;
                if (itemStack.getCount() == tempCopyStack.getCount()) continue block0;
                tempCopyStack.grow(itemStack.getCount());
                continue block0;
            }
            tempCopy.set(compressedIdx, (Object)itemStack.copy());
            ++compressedIdx;
            hasStuff = true;
        }
        if (!hasStuff && this.getHadStuff()) {
            this.setHadStuff(false);
            for (i = 0; i < this.getTopItems().size(); ++i) {
                this.getTopItems().set(i, (Object)ItemStack.EMPTY);
            }
            if (this.getChestLevel() != null) {
                BlockState blockState = this.getChestLevel().getBlockState(this.getChestWorldPosition());
                this.getChestLevel().sendBlockUpdated(this.getChestWorldPosition(), blockState, blockState, 3);
            }
            return;
        }
        this.setHadStuff(true);
        tempCopy.sort((stack1, stack2) -> {
            if (stack1.isEmpty()) {
                return 1;
            }
            if (stack2.isEmpty()) {
                return -1;
            }
            return stack2.getCount() - stack1.getCount();
        });
        int slot = 0;
        for (ItemStack itemStack : tempCopy) {
            if (itemStack.isEmpty() || itemStack.getCount() <= 0) continue;
            if (slot == this.getTopItems().size()) break;
            this.getTopItems().set(slot, (Object)itemStack);
            ++slot;
        }
        for (int i2 = slot; i2 < this.getTopItems().size(); ++i2) {
            this.getTopItems().set(i2, (Object)ItemStack.EMPTY);
        }
        if (this.getChestLevel() != null) {
            BlockState blockState = this.getChestLevel().getBlockState(this.getChestWorldPosition());
            this.getChestLevel().sendBlockUpdated(this.getChestWorldPosition(), blockState, blockState, 3);
        }
        this.sendTopStacksPacket();
    }

    public NonNullList<ItemStack> getCurrentItems();

    public void setHadStuff(boolean var1);

    public boolean getHadStuff();
}

