/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.block.regular.entity;

import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.block.regular.AbstractIronChestBlock;
import com.progwml6.ironchest.common.inventory.IronChestMenu;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class AbstractIronChestBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    private NonNullList<ItemStack> items;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState blockState) {
            AbstractIronChestBlockEntity.playSound(level, pos, blockState, SoundEvents.CHEST_OPEN);
        }

        protected void onClose(Level level, BlockPos pos, BlockState blockState) {
            AbstractIronChestBlockEntity.playSound(level, pos, blockState, SoundEvents.CHEST_CLOSE);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState blockState, int previousCount, int newCount) {
            AbstractIronChestBlockEntity.this.signalOpenCount(level, pos, blockState, previousCount, newCount);
        }

        public boolean isOwnContainer(Player player) {
            if (!(player.containerMenu instanceof IronChestMenu)) {
                return false;
            }
            Container container = ((IronChestMenu)player.containerMenu).getContainer();
            return container instanceof AbstractIronChestBlockEntity || container instanceof CompoundContainer && ((CompoundContainer)container).contains((Container)AbstractIronChestBlockEntity.this);
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    private final IronChestsTypes chestType;
    private final Supplier<Block> blockToUse;

    protected AbstractIronChestBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState, IronChestsTypes chestTypeIn, Supplier<Block> blockToUseIn) {
        super(blockEntityType, blockPos, blockState);
        this.items = NonNullList.withSize((int)chestTypeIn.size, (Object)ItemStack.EMPTY);
        this.chestType = chestTypeIn;
        this.blockToUse = blockToUseIn;
    }

    public int getContainerSize() {
        return this.getItems().size();
    }

    protected Component getDefaultName() {
        return Component.translatable((String)("ironchest.container." + this.chestType.getId() + "_chest"));
    }

    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(input)) {
            ContainerHelper.loadAllItems((ValueInput)input, this.items);
        }
    }

    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (!this.trySaveLootTable(output)) {
            ContainerHelper.saveAllItems((ValueOutput)output, this.items);
        }
    }

    public static void lidAnimateTick(Level level, BlockPos blockPos, BlockState blockState, AbstractIronChestBlockEntity chestBlockEntity) {
        chestBlockEntity.chestLidController.tickLid();
    }

    static void playSound(Level level, BlockPos blockPos, BlockState blockState, SoundEvent soundEvent) {
        double d0 = (double)blockPos.getX() + 0.5;
        double d1 = (double)blockPos.getY() + 0.5;
        double d2 = (double)blockPos.getZ() + 0.5;
        level.playSound(null, d0, d1, d2, soundEvent, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.chestLidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void startOpen(ContainerUser user) {
        if (!this.remove && !user.getLivingEntity().isSpectator()) {
            this.openersCounter.incrementOpeners(user.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState(), user.getContainerInteractionRange());
        }
    }

    public void stopOpen(ContainerUser user) {
        if (!this.remove && !user.getLivingEntity().isSpectator()) {
            this.openersCounter.decrementOpeners(user.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(NonNullList<ItemStack> itemsIn) {
        this.items = NonNullList.withSize((int)this.getChestType().size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < itemsIn.size(); ++i) {
            if (i >= this.items.size()) continue;
            this.getItems().set(i, (Object)((ItemStack)itemsIn.get(i)));
        }
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.getOpenness(partialTicks);
    }

    public static int getOpenCount(BlockGetter blockGetter, BlockPos blockPos) {
        BlockEntity blockentity;
        BlockState blockstate = blockGetter.getBlockState(blockPos);
        if (blockstate.hasBlockEntity() && (blockentity = blockGetter.getBlockEntity(blockPos)) instanceof AbstractIronChestBlockEntity) {
            return ((AbstractIronChestBlockEntity)blockentity).openersCounter.getOpenerCount();
        }
        return 0;
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void signalOpenCount(Level level, BlockPos blockPos, BlockState blockState, int previousCount, int newCount) {
        Block block = blockState.getBlock();
        level.blockEvent(blockPos, block, 1, newCount);
    }

    public IronChestsTypes getChestType() {
        IronChestsTypes typeFromBlock;
        IronChestsTypes type = IronChestsTypes.IRON;
        if (this.hasLevel() && (typeFromBlock = AbstractIronChestBlock.getTypeFromBlock(this.getBlockState().getBlock())) != null) {
            type = typeFromBlock;
        }
        return type;
    }

    public Block getBlockToUse() {
        return this.blockToUse.get();
    }
}

