/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.block.trapped.entity;

import com.progwml6.ironchest.common.Util;
import com.progwml6.ironchest.common.block.IronChestsBlocks;
import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.block.entity.IronChestsBlockEntityTypes;
import com.progwml6.ironchest.common.block.trapped.entity.AbstractTrappedIronChestBlockEntity;
import com.progwml6.ironchest.common.datacomponents.IronChestsDataComponents;
import com.progwml6.ironchest.common.inventory.IronChestMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueOutput;

public class TrappedDirtChestBlockEntity
extends AbstractTrappedIronChestBlockEntity {
    private static final ItemStack DIRT_CHEST_BOOK = Util.createDirtGuideBook();

    public TrappedDirtChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)IronChestsBlockEntityTypes.TRAPPED_DIRT_CHEST.get(), blockPos, blockState, IronChestsTypes.DIRT, () -> IronChestsBlocks.TRAPPED_DIRT_CHEST.get());
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory playerInventory) {
        return IronChestMenu.createDirtContainer(containerId, playerInventory, (Container)this);
    }

    public void preRemoveSideEffects(BlockPos blockPos, BlockState blockState) {
        if (!((ItemStack)this.getItems().get(0)).isEmpty() && ItemStack.isSameItem((ItemStack)((ItemStack)this.getItems().get(0)), (ItemStack)DIRT_CHEST_BOOK)) {
            this.getItems().set(0, (Object)ItemStack.EMPTY);
        }
        super.preRemoveSideEffects(blockPos, blockState);
    }

    @Override
    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putBoolean("chest_placed_already", true);
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        super.applyImplicitComponents(componentGetter);
        if (!((Boolean)componentGetter.getOrDefault((DataComponentType)IronChestsDataComponents.CHEST_PLACED_ALREADY.get(), (Object)false)).booleanValue()) {
            this.setItem(0, DIRT_CHEST_BOOK.copy());
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set((DataComponentType)IronChestsDataComponents.CHEST_PLACED_ALREADY.get(), (Object)true);
    }

    public void removeComponentsFromTag(ValueOutput output) {
        super.removeComponentsFromTag(output);
        output.discard("chest_placed_already");
    }
}

