/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.data;

import com.progwml6.ironchest.common.block.IronChestsBlocks;
import com.progwml6.ironchest.common.item.IronChestsItems;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class IronChestsLanguageProvider
extends LanguageProvider {
    public IronChestsLanguageProvider(PackOutput output, String locale) {
        super(output, "ironchest", locale);
    }

    protected void addTranslations() {
        this.addBlock((Supplier)IronChestsBlocks.IRON_CHEST, "Iron Chest");
        this.addBlock((Supplier)IronChestsBlocks.GOLD_CHEST, "Gold Chest");
        this.addBlock((Supplier)IronChestsBlocks.DIAMOND_CHEST, "Diamond Chest");
        this.addBlock((Supplier)IronChestsBlocks.COPPER_CHEST, "Copper Chest");
        this.addBlock((Supplier)IronChestsBlocks.CRYSTAL_CHEST, "Crystal Chest");
        this.addBlock((Supplier)IronChestsBlocks.OBSIDIAN_CHEST, "Obsidian Chest");
        this.addBlock((Supplier)IronChestsBlocks.DIRT_CHEST, "DirtChest 9000!");
        this.addBlock((Supplier)IronChestsBlocks.TRAPPED_IRON_CHEST, "Trapped Iron Chest");
        this.addBlock((Supplier)IronChestsBlocks.TRAPPED_GOLD_CHEST, "Trapped Gold Chest");
        this.addBlock((Supplier)IronChestsBlocks.TRAPPED_DIAMOND_CHEST, "Trapped Diamond Chest");
        this.addBlock((Supplier)IronChestsBlocks.TRAPPED_COPPER_CHEST, "Trapped Copper Chest");
        this.addBlock((Supplier)IronChestsBlocks.TRAPPED_CRYSTAL_CHEST, "Trapped Crystal Chest");
        this.addBlock((Supplier)IronChestsBlocks.TRAPPED_OBSIDIAN_CHEST, "Trapped Obsidian Chest");
        this.addBlock((Supplier)IronChestsBlocks.TRAPPED_DIRT_CHEST, "Trapped DirtChest 9000!");
        this.addItem((Supplier)IronChestsItems.IRON_TO_GOLD_CHEST_UPGRADE, "Iron to Gold Chest Upgrade");
        this.addItem((Supplier)IronChestsItems.GOLD_TO_DIAMOND_CHEST_UPGRADE, "Gold to Diamond Chest Upgrade");
        this.addItem((Supplier)IronChestsItems.COPPER_TO_IRON_CHEST_UPGRADE, "Copper to Iron Chest Upgrade");
        this.addItem((Supplier)IronChestsItems.DIAMOND_TO_CRYSTAL_CHEST_UPGRADE, "Diamond to Crystal Chest Upgrade");
        this.addItem((Supplier)IronChestsItems.WOOD_TO_IRON_CHEST_UPGRADE, "Wood to Iron Chest Upgrade");
        this.addItem((Supplier)IronChestsItems.WOOD_TO_COPPER_CHEST_UPGRADE, "Wood to Copper Chest Upgrade");
        this.addItem((Supplier)IronChestsItems.DIAMOND_TO_OBSIDIAN_CHEST_UPGRADE, "Diamond to Obsidian Chest Upgrade");
        this.addBookAndContents("dirtchest9000", "How to use your DirtChest 9000!", "Welcome to your new DirtChest 9000! We hope you will enjoy many happy years of storing your stack of dirt in our storage utility.", "Usage: simply insert the stack of dirt of your choice into the highly receptive slot and enjoy the great convenience of having that dirt available to you, any time you pass by this chest!", "We hope you have enjoyed reviewing this instruction manual, and hope you will consider using our products in future! Kind regards, The DirtChest 9000 manual writers incorporated.", "Warranty: This product has no warranty of any kind. Your dirt may not be stored, it may slowly leech into the environment, or alternatively, it may not do anything at all.", "DirtChest 9000 is kind to the environment. Please dispose of this guide book responsibly, and do not whatever you do just chuck it into some lava. We would be very sad.");
        this.add("itemGroup.ironchest", "Iron Chests");
        this.add("ironchest.container.iron_chest", "Iron Chest");
        this.add("ironchest.container.gold_chest", "Gold Chest");
        this.add("ironchest.container.diamond_chest", "Diamond Chest");
        this.add("ironchest.container.copper_chest", "Copper Chest");
        this.add("ironchest.container.silver_chest", "Silver Chest");
        this.add("ironchest.container.crystal_chest", "Crystal Chest");
        this.add("ironchest.container.obsidian_chest", "Obsidian Chest");
        this.add("ironchest.container.dirt_chest", "DirtChest 9000!");
    }

    public void addBookAndContents(String bookKey, String bookTitle, String ... pages) {
        this.add("ironchest.book." + bookKey, bookTitle);
        int pageCount = 0;
        for (String page : pages) {
            this.add("ironchest.book." + bookKey + "." + ++pageCount, page);
        }
    }
}

