/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.data;

import com.progwml6.ironchest.IronChests;
import com.progwml6.ironchest.common.block.IronChestsBlocks;
import com.progwml6.ironchest.common.item.IronChestsItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class IronChestsRecipeProvider
extends RecipeProvider {
    public IronChestsRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
    }

    protected void buildRecipes() {
        HolderLookup.RegistryLookup itemRegistryLookup = this.registries.lookupOrThrow(Registries.ITEM);
        this.addChestsRecipes((HolderGetter<Item>)itemRegistryLookup);
        this.addUpgradesRecipes((HolderGetter<Item>)itemRegistryLookup);
    }

    private void addChestsRecipes(HolderGetter<Item> itemRegistryLookup) {
        String folder = "chests/";
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.COPPER_CHEST.get())).define(Character.valueOf('M'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('S'), Tags.Items.CHESTS_WOODEN).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_copper_ingot", this.has(Tags.Items.INGOTS_COPPER)).save(this.output, this.createKey(folder + "vanilla_copper_chest"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.IRON_CHEST.get())).define(Character.valueOf('M'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.CHESTS_WOODEN).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_iron_ingot", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.createKey(folder + "vanilla_iron_chest"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.IRON_CHEST.get())).define(Character.valueOf('M'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)IronChestsBlocks.COPPER_CHEST.get()).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("MGM").pattern("GSG").pattern("MGM").unlockedBy("has_iron_ingot", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.createKey(folder + "copper_iron_chest"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.GOLD_CHEST.get())).define(Character.valueOf('M'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('S'), (ItemLike)IronChestsBlocks.IRON_CHEST.get()).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_gold_ingot", this.has(Tags.Items.INGOTS_GOLD)).save(this.output, this.createKey(folder + "iron_gold_chest"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.DIAMOND_CHEST.get())).define(Character.valueOf('M'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('S'), (ItemLike)IronChestsBlocks.GOLD_CHEST.get()).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("GGG").pattern("MSM").pattern("GGG").unlockedBy("has_diamonds", this.has(Tags.Items.GEMS_DIAMOND)).save(this.output, this.createKey(folder + "gold_diamond_chest"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.OBSIDIAN_CHEST.get())).define(Character.valueOf('M'), (ItemLike)Blocks.OBSIDIAN).define(Character.valueOf('S'), (ItemLike)IronChestsBlocks.DIAMOND_CHEST.get()).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_obsidian", this.has((ItemLike)Blocks.OBSIDIAN)).save(this.output, this.createKey(folder + "diamond_obsidian_chest"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.CRYSTAL_CHEST.get())).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('S'), (ItemLike)IronChestsBlocks.DIAMOND_CHEST.get()).pattern("GGG").pattern("GSG").pattern("GGG").unlockedBy("has_glass", this.has(Tags.Items.GLASS_BLOCKS)).save(this.output, this.createKey(folder + "diamond_crystal_chest"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.DIRT_CHEST.get())).define(Character.valueOf('M'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DIRT, Blocks.COARSE_DIRT, Blocks.PODZOL})).define(Character.valueOf('S'), Tags.Items.CHESTS_WOODEN).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_iron_ingot", this.has((ItemLike)Blocks.DIRT)).save(this.output, this.createKey(folder + "vanilla_dirt_chest"));
        ShapelessRecipeBuilder.shapeless(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_IRON_CHEST.get())).requires((ItemLike)IronChestsBlocks.IRON_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", this.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(this.output, this.createKey(folder + "trapped_iron_chest"));
        ShapelessRecipeBuilder.shapeless(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_GOLD_CHEST.get())).requires((ItemLike)IronChestsBlocks.GOLD_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", this.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(this.output, this.createKey(folder + "trapped_gold_chest"));
        ShapelessRecipeBuilder.shapeless(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_DIAMOND_CHEST.get())).requires((ItemLike)IronChestsBlocks.DIAMOND_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", this.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(this.output, this.createKey(folder + "trapped_diamond_chest"));
        ShapelessRecipeBuilder.shapeless(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_COPPER_CHEST.get())).requires((ItemLike)IronChestsBlocks.COPPER_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", this.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(this.output, this.createKey(folder + "trapped_copper_chest"));
        ShapelessRecipeBuilder.shapeless(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_CRYSTAL_CHEST.get())).requires((ItemLike)IronChestsBlocks.CRYSTAL_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", this.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(this.output, this.createKey(folder + "trapped_crystal_chest"));
        ShapelessRecipeBuilder.shapeless(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_OBSIDIAN_CHEST.get())).requires((ItemLike)IronChestsBlocks.OBSIDIAN_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", this.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(this.output, this.createKey(folder + "trapped_obsidian_chest"));
        ShapelessRecipeBuilder.shapeless(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsBlocks.TRAPPED_DIRT_CHEST.get())).requires((ItemLike)IronChestsBlocks.DIRT_CHEST.get()).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", this.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(this.output, this.createKey(folder + "trapped_dirt_chest"));
    }

    private void addUpgradesRecipes(HolderGetter<Item> itemRegistryLookup) {
        String folder = "upgrades/";
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsItems.WOOD_TO_COPPER_CHEST_UPGRADE.get())).define(Character.valueOf('M'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('P'), ItemTags.PLANKS).pattern("MMM").pattern("MPM").pattern("MMM").unlockedBy("has_copper_ingot", this.has(Tags.Items.INGOTS_COPPER)).save(this.output, this.createKey(folder + "wood_to_copper_chest_upgrade"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsItems.WOOD_TO_IRON_CHEST_UPGRADE.get())).define(Character.valueOf('M'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), ItemTags.PLANKS).pattern("MMM").pattern("MPM").pattern("MMM").unlockedBy("has_iron_ingot", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.createKey(folder + "wood_to_iron_chest_upgrade"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsItems.COPPER_TO_IRON_CHEST_UPGRADE.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("IGI").pattern("GCG").pattern("IGI").unlockedBy("has_iron_ingot", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.createKey(folder + "copper_to_iron_chest_upgrade"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsItems.IRON_TO_GOLD_CHEST_UPGRADE.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).pattern("GGG").pattern("GIG").pattern("GGG").unlockedBy("has_iron_ingot", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.createKey(folder + "iron_to_gold_chest_upgrade"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsItems.GOLD_TO_DIAMOND_CHEST_UPGRADE.get())).define(Character.valueOf('M'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('S'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("GGG").pattern("MSM").pattern("GGG").unlockedBy("has_glass", this.has(Tags.Items.GLASS_BLOCKS)).save(this.output, this.createKey(folder + "gold_to_diamond_chest_upgrade"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsItems.DIAMOND_TO_OBSIDIAN_CHEST_UPGRADE.get())).define(Character.valueOf('M'), (ItemLike)Blocks.OBSIDIAN).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("MMM").pattern("MGM").pattern("MMM").unlockedBy("has_glass", this.has(Tags.Items.GLASS_BLOCKS)).save(this.output, this.createKey(folder + "diamond_to_obsidian_chest_upgrade"));
        ShapedRecipeBuilder.shaped(itemRegistryLookup, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)IronChestsItems.DIAMOND_TO_CRYSTAL_CHEST_UPGRADE.get())).define(Character.valueOf('M'), (ItemLike)Blocks.OBSIDIAN).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("GGG").pattern("GMG").pattern("GGG").unlockedBy("has_glass", this.has(Tags.Items.GLASS_BLOCKS)).save(this.output, this.createKey(folder + "diamond_to_crystal_chest_upgrade"));
    }

    protected ResourceKey<Recipe<?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)IronChests.prefix(name));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
            return new IronChestsRecipeProvider(provider, output);
        }

        public String getName() {
            return "Iron Chest Boxes Recipes";
        }
    }
}

