/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n;

import io.github.kgriff0n.ServersLink;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class PlayersInformation {
    private static final HashMap<UUID, String> lastServer = new HashMap();

    public static void setLastServer(UUID player, String serverName) {
        lastServer.put(player, serverName);
    }

    public static String getLastServer(UUID player) {
        return lastServer.get(player);
    }

    public static void saveNbt(MinecraftServer server) {
        class_2487 nbt = new class_2487();
        lastServer.forEach((uuid, name) -> nbt.method_10582(uuid.toString(), name));
        Path dataFile = server.method_27050(class_5218.field_24188).resolve("data").resolve("servers_link.nbt");
        try (OutputStream os = Files.newOutputStream(dataFile, new OpenOption[0]);){
            class_2507.method_10634((class_2487)nbt, (OutputStream)os);
        }
        catch (IOException e) {
            ServersLink.LOGGER.error("Unable to save data");
        }
    }

    public static void loadNbt(MinecraftServer server) {
        Path dataFile = server.method_27050(class_5218.field_24188).resolve("data").resolve("servers_link.nbt");
        try (InputStream is = Files.newInputStream(dataFile, new OpenOption[0]);){
            class_2487 nbt = class_2507.method_10629((InputStream)is, (class_2505)class_2505.method_53898());
            for (String uuid : nbt.method_10541()) {
                UUID player = UUID.fromString(uuid);
                nbt.method_10558(uuid).ifPresent(string -> lastServer.put(player, (String)string));
            }
        }
        catch (IOException e) {
            ServersLink.LOGGER.error("Unable to load data");
        }
    }
}

