/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.api;

import com.mojang.authlib.GameProfile;
import io.github.kgriff0n.ServersLink;
import io.github.kgriff0n.event.ServerTick;
import io.github.kgriff0n.packet.Packet;
import io.github.kgriff0n.packet.info.ServersInfoPacket;
import io.github.kgriff0n.packet.play.PlayerDisconnectPacket;
import io.github.kgriff0n.packet.play.PlayerTransferPacket;
import io.github.kgriff0n.server.ServerInfo;
import io.github.kgriff0n.socket.G2SConnection;
import io.github.kgriff0n.socket.Gateway;
import io.github.kgriff0n.socket.SubServer;
import io.github.kgriff0n.util.DummyPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import net.minecraft.class_9151;
import org.jetbrains.annotations.Nullable;

public class ServersLinkApi {
    private static final HashMap<ServerInfo, G2SConnection> serverList = new HashMap();
    private static final HashSet<UUID> preventConnect = new HashSet();
    private static final HashSet<UUID> preventDisconnect = new HashSet();
    public static List<DummyPlayer> dummyPlayers = new ArrayList<DummyPlayer>();

    public static HashSet<UUID> getPreventConnect() {
        return preventConnect;
    }

    public static HashSet<UUID> getPreventDisconnect() {
        return preventDisconnect;
    }

    public static HashMap<ServerInfo, G2SConnection> getServerMap() {
        return serverList;
    }

    public static ArrayList<ServerInfo> getServerList() {
        return new ArrayList<ServerInfo>(serverList.keySet());
    }

    public static void setServerList(ArrayList<ServerInfo> list) {
        serverList.clear();
        for (ServerInfo server : list) {
            serverList.put(server, null);
        }
    }

    public static ArrayList<String> getServerNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ServerInfo server : serverList.keySet()) {
            names.add(server.getName());
        }
        return names;
    }

    public static ArrayList<ServerInfo> getServers(String groupId) {
        ArrayList<ServerInfo> list = new ArrayList<ServerInfo>();
        for (ServerInfo server : serverList.keySet()) {
            if (!server.getGroupId().equals(groupId)) continue;
            list.add(server);
        }
        return list;
    }

    public static ServerInfo getServer(String serverName) {
        for (ServerInfo server : serverList.keySet()) {
            if (!server.getName().equals(serverName)) continue;
            return server;
        }
        return null;
    }

    public static void addServer(ServerInfo server, @Nullable G2SConnection connection) {
        ServersLink.SERVER.execute(() -> {
            serverList.remove(server);
            serverList.put(server, connection);
        });
    }

    public static void disconnectServer(ServerInfo server) {
        ServersLink.SERVER.execute(() -> {
            Gateway gateway = Gateway.getInstance();
            server.getPlayersList().forEach((uuid, name) -> {
                gateway.sendAll(new PlayerDisconnectPacket((UUID)uuid));
                dummyPlayers.removeIf(player -> player.method_5667().equals(uuid));
            });
            gateway.sendAll(new ServersInfoPacket(ServersLinkApi.getServerList()));
            server.getPlayersList().clear();
            server.getGameProfile().clear();
            serverList.put(server, null);
        });
    }

    public static int getRunningSubServers() {
        int count = 0;
        for (G2SConnection connection : serverList.values()) {
            if (connection == null) continue;
            ++count;
        }
        return count;
    }

    public static String whereIs(UUID uuid) {
        for (ServerInfo serverInfo : ServersLinkApi.getServerList()) {
            if (!serverInfo.getPlayersList().containsKey(uuid)) continue;
            return serverInfo.getName();
        }
        return null;
    }

    public static void send(Packet packet, String source) {
        if (ServersLink.isGateway) {
            Gateway.getInstance().forward(packet, source);
        } else {
            SubServer.getInstance().send(packet);
        }
    }

    public static void broadcastToOp(class_2561 text) {
        for (String playerName : ServersLink.SERVER.method_3760().method_14603().method_14636()) {
            class_3222 player = ServersLink.SERVER.method_3760().method_14566(playerName);
            if (player == null || player instanceof DummyPlayer) continue;
            player.method_64398(text);
        }
    }

    public static void addDummyPlayer(GameProfile profile) {
        List playerList = ServersLink.SERVER.method_3760().method_14571();
        boolean alreadyPresent = false;
        for (DummyPlayer player : dummyPlayers) {
            if (!player.method_5667().equals(profile.getId())) continue;
            alreadyPresent = true;
        }
        if (!alreadyPresent) {
            dummyPlayers.add(new DummyPlayer(profile));
            ArrayList<DummyPlayer> allPlayers = new ArrayList<DummyPlayer>();
            allPlayers.addAll(playerList);
            allPlayers.addAll(dummyPlayers);
            for (class_3222 player : playerList) {
                player.field_13987.method_14364((class_2596)class_2703.method_43886(allPlayers));
            }
        }
    }

    public static List<DummyPlayer> getDummyPlayers() {
        return dummyPlayers;
    }

    public static class_3222 getDummyPlayer(UUID uuid) {
        for (DummyPlayer player : dummyPlayers) {
            if (!player.method_5667().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public static class_3222 getDummyPlayer(String playerName) {
        for (DummyPlayer player : dummyPlayers) {
            if (!player.method_5820().equals(playerName)) continue;
            return player;
        }
        return null;
    }

    public static void transferPlayer(class_3222 player, String originServer, String serverName) {
        ServerInfo server = ServersLinkApi.getServer(serverName);
        if (ServersLink.isGateway) {
            PlayerTransferPacket transferPacket = new PlayerTransferPacket(player.method_5667(), serverName);
            transferPacket.onGatewayReceive(originServer);
        } else {
            SubServer connection = SubServer.getInstance();
            connection.send(new PlayerTransferPacket(player.method_5667(), serverName));
        }
        player.field_13987.method_14364((class_2596)new class_9151(server.getIp(), server.getPort()));
        ServerTick.scheduleDisconnect(player.method_5667(), 20);
    }
}

