/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.event;

import io.github.kgriff0n.ServersLink;
import io.github.kgriff0n.api.ServersLinkApi;
import io.github.kgriff0n.packet.info.ServerStatusPacket;
import io.github.kgriff0n.packet.info.ServersInfoPacket;
import io.github.kgriff0n.socket.Gateway;
import io.github.kgriff0n.socket.SubServer;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerTick
implements ServerTickEvents.StartTick {
    private static final ConcurrentHashMap<UUID, Integer> shouldDisconnect = new ConcurrentHashMap();
    private int count = 0;

    public static void scheduleDisconnect(UUID player, int ticks) {
        shouldDisconnect.put(player, ticks);
    }

    public void onStartTick(MinecraftServer server) {
        ++this.count;
        if (this.count >= 600) {
            this.count = 0;
            float tps = server.method_54833().method_54748();
            ServersLink.getServerInfo().setTps(tps);
            if (ServersLink.isGateway) {
                Gateway.getInstance().sendAll(new ServersInfoPacket(ServersLinkApi.getServerList()));
            } else {
                SubServer.getInstance().send(new ServerStatusPacket(ServersLink.getServerInfo().getName(), tps, false));
            }
        }
        Iterator<Map.Entry<UUID, Integer>> players = shouldDisconnect.entrySet().iterator();
        while (players.hasNext()) {
            Map.Entry<UUID, Integer> playerEntry = players.next();
            int ticksLeft = playerEntry.getValue() - 1;
            if (ticksLeft <= 0) {
                class_3222 player = server.method_3760().method_14602(playerEntry.getKey());
                if (player != null && !player.method_14239()) {
                    player.field_13987.method_52396((class_2561)class_2561.method_43471((String)"connect.transferring"));
                }
                players.remove();
                continue;
            }
            playerEntry.setValue(ticksLeft);
        }
    }
}

