/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.mixin;

import com.mojang.authlib.GameProfile;
import io.github.kgriff0n.ServersLink;
import io.github.kgriff0n.api.ServersLinkApi;
import io.github.kgriff0n.server.ServerInfo;
import io.github.kgriff0n.socket.Gateway;
import java.util.ArrayList;
import net.minecraft.class_2926;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    public abstract int method_3802();

    @Inject(at={@At(value="HEAD")}, method={"createMetadataPlayers"}, cancellable=true)
    private void customPlayerCount(CallbackInfoReturnable<class_2926.class_2927> cir) {
        if (ServersLink.isGateway && Gateway.getInstance().isGlobalPlayerCountEnabled()) {
            int maxPlayers = this.method_3802();
            int playerCount = 0;
            ArrayList<GameProfile> players = new ArrayList<GameProfile>();
            for (ServerInfo server : ServersLinkApi.getServerList()) {
                playerCount += server.getPlayersList().size();
                players.addAll(server.getGameProfile());
            }
            cir.setReturnValue((Object)new class_2926.class_2927(maxPlayers, playerCount, players));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getCurrentPlayerCount"}, cancellable=true)
    private void getCurrentPlayerCount(CallbackInfoReturnable<Integer> cir) {
        if (ServersLink.isGateway && Gateway.getInstance().isGlobalPlayerCountEnabled()) {
            int playerCount = 0;
            for (ServerInfo server : ServersLinkApi.getServerList()) {
                playerCount += server.getPlayersList().size();
            }
            cir.setReturnValue((Object)playerCount);
        }
    }
}

