/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.mixin;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import io.github.kgriff0n.util.IPlayerServersLink;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements IPlayerServersLink {
    @Unique
    private HashMap<String, class_243> serversPos = new HashMap();
    @Unique
    private HashMap<String, List<Float>> serversRot = new HashMap();
    @Unique
    private HashMap<String, class_3218> serversDim = new HashMap();

    @Inject(at={@At(value="HEAD")}, method={"writeCustomData"})
    private void writeNbt(class_11372 view, CallbackInfo ci) {
        String name;
        class_11372 serversLink = view.method_71461("ServersLink");
        class_11372 posView = serversLink.method_71461("Position");
        class_11372 rotView = serversLink.method_71461("Rotation");
        class_11372 dimView = serversLink.method_71461("Dimension");
        for (Map.Entry<String, class_243> entry : this.serversPos.entrySet()) {
            name = entry.getKey();
            class_243 pos = entry.getValue();
            class_11372.class_11373 posAppender = posView.method_71467(name, (Codec)Codec.DOUBLE);
            posAppender.method_71484((Object)pos.method_10216());
            posAppender.method_71484((Object)pos.method_10214());
            posAppender.method_71484((Object)pos.method_10215());
        }
        for (Map.Entry<String, Object> entry : this.serversRot.entrySet()) {
            name = entry.getKey();
            List rot = (List)entry.getValue();
            class_11372.class_11373 rotAppender = rotView.method_71467(name, (Codec)Codec.FLOAT);
            rotAppender.method_71484((Object)((Float)rot.get(0)));
            rotAppender.method_71484((Object)((Float)rot.get(1)));
        }
        for (Map.Entry<String, Object> entry : this.serversDim.entrySet()) {
            name = entry.getKey();
            class_3218 dim = (class_3218)entry.getValue();
            dimView.method_71469(name, dim.method_27983().method_29177().toString().split(":")[1]);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"readCustomData"})
    private void readNbt(class_11368 view, CallbackInfo ci) {
        UnboundedMapCodec posMapCodec = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.list((Codec)Codec.DOUBLE));
        UnboundedMapCodec dimMapCodec = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
        UnboundedMapCodec rotMapCodec = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.list((Codec)Codec.FLOAT));
        view.method_71420("ServersLink").flatMap(arg_0 -> PlayerEntityMixin.lambda$readNbt$0((Codec)posMapCodec, arg_0)).ifPresent(posMap -> {
            this.serversPos = new HashMap();
            posMap.forEach((server, coords) -> {
                if (coords.size() >= 3) {
                    this.serversPos.put((String)server, new class_243(((Double)coords.get(0)).doubleValue(), ((Double)coords.get(1)).doubleValue(), ((Double)coords.get(2)).doubleValue()));
                }
            });
        });
        view.method_71420("ServersLink").flatMap(arg_0 -> PlayerEntityMixin.lambda$readNbt$3((Codec)rotMapCodec, arg_0)).ifPresent(rotMap -> {
            this.serversRot = new HashMap();
            rotMap.forEach((server, rotations) -> {
                if (rotations.size() >= 2) {
                    this.serversRot.put((String)server, List.of((Float)rotations.get(0), (Float)rotations.get(1)));
                }
            });
        });
        view.method_71420("ServersLink").flatMap(arg_0 -> PlayerEntityMixin.lambda$readNbt$6((Codec)dimMapCodec, arg_0)).ifPresent(dimMap -> {
            this.serversDim = new HashMap();
            dimMap.forEach((server, dimId) -> {
                class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60656((String)dimId));
                class_3218 world = Objects.requireNonNull(((class_1657)this).method_5682()).method_3847(key);
                if (world instanceof class_3218) {
                    class_3218 serverWorld = world;
                    this.serversDim.put((String)server, serverWorld);
                }
            });
        });
    }

    @Override
    public void servers_link$setServerPos(String name, class_243 pos) {
        this.serversPos.put(name, pos);
    }

    @Override
    public class_243 servers_link$getServerPos(String name) {
        return this.serversPos.get(name);
    }

    @Override
    public void servers_link$removeServerPos(String name) {
        this.serversPos.remove(name);
    }

    @Override
    public void servers_link$setServerRot(String name, float yaw, float pitch) {
        List<Float> rot = List.of(Float.valueOf(yaw), Float.valueOf(pitch));
        this.serversRot.put(name, rot);
    }

    @Override
    public List<Float> servers_link$getServerRot(String name) {
        return this.serversRot.get(name);
    }

    @Override
    public void servers_link$removeServerRot(String name) {
        this.serversRot.remove(name);
    }

    @Override
    public void servers_link$setServerDim(String name, class_3218 dim) {
        this.serversDim.put(name, dim);
    }

    @Override
    public class_3218 servers_link$getServerDim(String name) {
        return this.serversDim.get(name);
    }

    @Override
    public void servers_link$removeServerDim(String name) {
        this.serversDim.remove(name);
    }

    private static /* synthetic */ Optional lambda$readNbt$6(Codec dimMapCodec, class_11368 v) {
        return v.method_71426("Dimension", dimMapCodec);
    }

    private static /* synthetic */ Optional lambda$readNbt$3(Codec rotMapCodec, class_11368 v) {
        return v.method_71426("Rotation", rotMapCodec);
    }

    private static /* synthetic */ Optional lambda$readNbt$0(Codec posMapCodec, class_11368 v) {
        return v.method_71426("Position", posMapCodec);
    }
}

