/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.mixin;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.kgriff0n.ServersLink;
import io.github.kgriff0n.api.ServersLinkApi;
import io.github.kgriff0n.packet.play.SystemChatPacket;
import io.github.kgriff0n.packet.server.PlayerDataPacket;
import io.github.kgriff0n.util.DummyPlayer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2535;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7471;
import net.minecraft.class_7604;
import net.minecraft.class_8792;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3324.class})
public abstract class PlayerManagerMixin {
    @Shadow
    @Final
    private List<class_3222> field_14351;
    @Unique
    private class_3222 player;

    @Shadow
    public abstract void method_43514(class_2561 var1, boolean var2);

    @Shadow
    public abstract void method_14581(class_2596<?> var1);

    @Inject(at={@At(value="HEAD")}, method={"broadcast(Lnet/minecraft/text/Text;Z)V"})
    private void sendSystemPacket(class_2561 message, boolean overlay, CallbackInfo ci) {
        SystemChatPacket packet = new SystemChatPacket(((JsonElement)class_8824.field_46597.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)ServersLink.SERVER.method_30611()), (Object)message).getOrThrow()).toString());
        ServersLinkApi.send(packet, ServersLink.getServerInfo().getName());
    }

    @Inject(at={@At(value="HEAD")}, method={"onPlayerConnect"})
    private void getPlayer(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        this.player = player;
    }

    @Inject(at={@At(value="TAIL")}, method={"savePlayerData"})
    private void sendPlayerData(class_3222 player, CallbackInfo ci) {
        try {
            ServersLinkApi.send(new PlayerDataPacket(player.method_5667()), ServersLink.getServerInfo().getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Redirect(method={"onPlayerConnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;broadcast(Lnet/minecraft/text/Text;Z)V"))
    private void preventConnectMessage(class_3324 instance, class_2561 message, boolean overlay) {
        if (ServersLinkApi.getPreventConnect().contains(this.player.method_5667())) {
            ServersLinkApi.getPreventConnect().remove(this.player.method_5667());
        } else {
            this.method_43514(message, overlay);
        }
    }

    @Redirect(method={"onPlayerConnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;sendToAll(Lnet/minecraft/network/packet/Packet;)V"))
    private void sendPlayerList(class_3324 instance, class_2596<?> packet) {
        ArrayList<class_3222> allPlayers = new ArrayList<class_3222>();
        allPlayers.addAll(this.field_14351);
        allPlayers.addAll(ServersLinkApi.getDummyPlayers());
        this.method_14581((class_2596<?>)class_2703.method_43886(allPlayers));
    }

    @Inject(at={@At(value="HEAD")}, method={"savePlayerData"}, cancellable=true)
    private void savePlayerDataThreadSafe(class_3222 player, CallbackInfo ci) {
        if (player instanceof DummyPlayer) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"broadcast(Lnet/minecraft/network/message/SignedMessage;Ljava/util/function/Predicate;Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/network/message/MessageType$Parameters;)V"})
    private void broadcastDummy(class_7471 message, Predicate<class_3222> shouldSendFiltered, @Nullable class_3222 sender, class_2556.class_7602 params, CallbackInfo ci) {
        class_7604 sentMessage = class_7604.method_44857((class_7471)message);
        for (class_3222 class_32222 : ServersLinkApi.getDummyPlayers()) {
            boolean bl3 = shouldSendFiltered.test(class_32222);
            class_32222.method_43505(sentMessage, bl3, params);
        }
    }
}

