/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.packet.play;

import io.github.kgriff0n.PlayersInformation;
import io.github.kgriff0n.ServersLink;
import io.github.kgriff0n.api.ServersLinkApi;
import io.github.kgriff0n.packet.Packet;
import io.github.kgriff0n.packet.server.PreventConnectPacket;
import io.github.kgriff0n.packet.server.PreventDisconnectPacket;
import io.github.kgriff0n.server.Settings;
import io.github.kgriff0n.socket.Gateway;
import io.github.kgriff0n.socket.SubServer;
import java.util.UUID;

public class PlayerTransferPacket
implements Packet {
    private final UUID uuid;
    private final String serverToTransfer;

    public PlayerTransferPacket(UUID uuid, String serverToTransfer) {
        this.uuid = uuid;
        this.serverToTransfer = serverToTransfer;
    }

    @Override
    public boolean shouldReceive(Settings settings) {
        return false;
    }

    @Override
    public void onReceive() {
        if (!ServersLink.isGateway) {
            SubServer.getInstance().addWaitingPlayer(this.uuid);
        }
    }

    @Override
    public void onGatewayReceive(String sender) {
        Gateway gateway = Gateway.getInstance();
        Settings settings = gateway.getSettings(ServersLinkApi.getServer(sender).getGroupId(), ServersLinkApi.getServer(this.serverToTransfer).getGroupId());
        if (this.serverToTransfer.equals(ServersLink.getServerInfo().getName())) {
            if (settings.isPlayerListSynced()) {
                ServersLinkApi.getPreventConnect().add(this.uuid);
                gateway.sendTo(new PreventDisconnectPacket(this.uuid), sender);
            }
        } else {
            gateway.sendTo(this, this.serverToTransfer);
            if (settings.isPlayerListSynced()) {
                gateway.sendTo(new PreventConnectPacket(this.uuid), this.serverToTransfer);
                gateway.sendTo(new PreventDisconnectPacket(this.uuid), sender);
            }
        }
        gateway.removePlayer(this.uuid);
        PlayersInformation.setLastServer(this.uuid, this.serverToTransfer);
    }
}

