/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.packet.server;

import io.github.kgriff0n.ServersLink;
import io.github.kgriff0n.packet.Packet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class UpdateRolesPacket
implements Packet {
    private static final Path OP_PATH = FabricLoader.getInstance().getGameDir().resolve("ops.json");
    private static final Path ROLES_PATH = FabricLoader.getInstance().getGameDir().resolve("playerdata").resolve("player_roles");
    private final byte[] ops = this.readOps();
    private final byte[] playerRoles = (byte[])(FabricLoader.getInstance().isModLoaded("player-roles") && ROLES_PATH.toFile().exists() ? this.readPlayerRoles() : null);

    @Override
    public void onReceive() {
        try {
            this.writeOps();
            if (FabricLoader.getInstance().isModLoaded("player-roles")) {
                this.writePlayerRoles();
            }
        }
        catch (IOException e) {
            ServersLink.LOGGER.error("Unable to write whitelist");
        }
    }

    private byte[] readOps() throws IOException {
        return Files.readAllBytes(OP_PATH);
    }

    private byte[] readPlayerRoles() throws IOException {
        return Files.readAllBytes(ROLES_PATH);
    }

    private void writeOps() throws IOException {
        Files.write(OP_PATH, this.ops, new OpenOption[0]);
    }

    private void writePlayerRoles() throws IOException {
        Files.write(ROLES_PATH, this.playerRoles, new OpenOption[0]);
    }
}

