/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.server;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class ServerInfo
implements Serializable {
    private final String groupId;
    private final String name;
    private final String ip;
    private final int port;
    private final int randomValue;
    private float tps;
    private boolean down;
    private final HashMap<UUID, String> playersList;
    private final HashMap<UUID, String> playersPropertiesList;

    public ServerInfo(String groupId, String name, String ip, int port) {
        this.groupId = groupId;
        this.name = name;
        this.ip = ip;
        this.port = port;
        this.tps = 20.0f;
        this.down = false;
        this.playersList = new HashMap();
        this.playersPropertiesList = new HashMap();
        this.randomValue = new Random().nextInt();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public HashMap<UUID, String> getPlayersList() {
        return this.playersList;
    }

    public List<GameProfile> getGameProfile() {
        ArrayList<GameProfile> list = new ArrayList<GameProfile>();
        for (Map.Entry<UUID, String> entry : this.playersList.entrySet()) {
            PropertyMap properties = new PropertyMap.Serializer().deserialize(JsonParser.parseString((String)this.playersPropertiesList.get(entry.getKey())), null, null);
            GameProfile profile = new GameProfile(entry.getKey(), entry.getValue());
            PropertyMap gameProfileProperties = profile.getProperties();
            properties.forEach((arg_0, arg_1) -> ((PropertyMap)gameProfileProperties).put(arg_0, arg_1));
            list.add(profile);
        }
        return list;
    }

    public void addPlayer(GameProfile profile) {
        this.playersList.put(profile.getId(), profile.getName());
        this.playersPropertiesList.put(profile.getId(), new Gson().toJson(new PropertyMap.Serializer().serialize(profile.getProperties(), null, null)));
    }

    public void addPlayer(UUID uuid, String name, String properties) {
        this.playersList.put(uuid, name);
        this.playersPropertiesList.put(uuid, properties);
    }

    public void removePlayer(UUID uuid) {
        this.playersList.remove(uuid);
        this.playersPropertiesList.remove(uuid);
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean down) {
        this.down = down;
    }

    public float getTps() {
        return this.tps;
    }

    public void setTps(float tps) {
        this.tps = tps;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerInfo) {
            ServerInfo serverInfo = (ServerInfo)obj;
            return serverInfo.name.equals(this.name);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[group=%s,player_list=%s,rng=%s]", this.getName(), this.getGroupId(), new ArrayList<UUID>(this.playersList.keySet()), this.randomValue);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

