/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.socket;

import io.github.kgriff0n.ServersLink;
import io.github.kgriff0n.packet.Packet;
import io.github.kgriff0n.packet.info.NewServerPacket;
import io.github.kgriff0n.packet.info.ServerStatusPacket;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SubServer
extends Thread {
    private static SubServer connection;
    private ExecutorService executor;
    private ArrayList<UUID> waitingPlayers;
    private Socket clientSocket;
    private ObjectInputStream in;
    private ObjectOutputStream out;

    public static SubServer getInstance() {
        return connection;
    }

    public SubServer(String ip, int port) {
        if (connection == null) {
            this.waitingPlayers = new ArrayList();
            try {
                this.clientSocket = new Socket(ip, port);
                this.out = new ObjectOutputStream(this.clientSocket.getOutputStream());
                this.out.flush();
                this.in = new ObjectInputStream(this.clientSocket.getInputStream());
            }
            catch (IOException e) {
                ServersLink.LOGGER.error("Unable to establish connection");
            }
            connection = this;
            this.executor = Executors.newSingleThreadExecutor();
        } else {
            ServersLink.LOGGER.error("Connection already established");
        }
    }

    public synchronized void send(Packet packet) {
        if (this.executor.isShutdown()) {
            ServersLink.LOGGER.warn("Can't send {}", (Object)packet.getClass().getName());
        } else {
            this.executor.submit(() -> {
                try {
                    this.out.writeObject(packet);
                    this.out.flush();
                    this.out.reset();
                }
                catch (IOException e) {
                    ServersLink.LOGGER.error("Unable to send {}", (Object)packet.getClass().getName());
                }
            });
        }
    }

    public ArrayList<UUID> getWaitingPlayers() {
        return this.waitingPlayers;
    }

    public void addWaitingPlayer(UUID uuid) {
        this.waitingPlayers.add(uuid);
    }

    public void removeWaitingPlayer(UUID uuid) {
        this.waitingPlayers.remove(uuid);
    }

    @Override
    public void run() {
        try {
            this.send(new NewServerPacket(ServersLink.getServerInfo()));
            this.send(new ServerStatusPacket(ServersLink.getServerInfo().getName(), 20.0f, false));
            while (ServersLink.IS_RUNNING) {
                try {
                    Packet pkt = (Packet)this.in.readObject();
                    ServersLink.SERVER.execute(pkt::onReceive);
                }
                catch (ClassNotFoundException e) {
                    ServersLink.LOGGER.error("Receive invalid data");
                }
            }
        }
        catch (IOException e) {
            ServersLink.LOGGER.error("Gateway disconnected");
            ServersLink.SERVER.method_3747(true);
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.executor.shutdown();
    }
}

