/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.util;

import io.github.kgriff0n.ServersLink;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;

public class PlayerData {
    private static final Path PATH = FabricLoader.getInstance().getGameDir().resolve(ServersLink.SERVER.method_27728().method_150());

    public static Path getDataPath(UUID uuid) {
        Path playerPath = PATH.resolve("playerdata").resolve(String.valueOf(uuid) + ".dat");
        return playerPath;
    }

    public static Path getAdvancementsPath(UUID uuid) {
        File file = PATH.toFile();
        file.mkdir();
        return PATH.resolve("advancements").resolve(String.valueOf(uuid) + ".json");
    }

    public static Path getStatsPath(UUID uuid) {
        return PATH.resolve("stats").resolve(String.valueOf(uuid) + ".json");
    }

    public static byte[] readData(UUID uuid) throws IOException {
        return Files.readAllBytes(PlayerData.getDataPath(uuid));
    }

    public static byte[] readAdvancements(UUID uuid) throws IOException {
        return Files.readAllBytes(PlayerData.getAdvancementsPath(uuid));
    }

    public static byte[] readStats(UUID uuid) throws IOException {
        return Files.readAllBytes(PlayerData.getStatsPath(uuid));
    }

    public static void writeData(UUID uuid, byte[] data) throws IOException {
        Files.write(PlayerData.getDataPath(uuid), data, new OpenOption[0]);
    }

    public static void writeAdvancements(UUID uuid, byte[] data) throws IOException {
        File dir = PATH.resolve("advancements").toFile();
        if (!dir.exists()) {
            dir.mkdir();
        }
        Files.write(PlayerData.getAdvancementsPath(uuid), data, new OpenOption[0]);
    }

    public static void writeStats(UUID uuid, byte[] data) throws IOException {
        File dir = PATH.resolve("stats").toFile();
        if (!dir.exists()) {
            dir.mkdir();
        }
        Files.write(PlayerData.getStatsPath(uuid), data, new OpenOption[0]);
    }
}

