/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import io.github.kgriff0n.ServersLink;
import io.github.kgriff0n.api.ServersLinkApi;
import io.github.kgriff0n.packet.play.TeleportationAcceptPacket;
import io.github.kgriff0n.packet.play.TeleportationRequestPacket;
import io.github.kgriff0n.server.ServerInfo;
import io.github.kgriff0n.socket.Gateway;
import io.github.kgriff0n.socket.SubServer;
import io.github.kgriff0n.util.IPlayerServersLink;
import java.util.EnumSet;
import java.util.Locale;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ServerCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"server").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Permissions.require((String)"server.list", (int)2))).executes(context -> ServerCommand.list((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"join").requires(Permissions.require((String)"server.join", (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"server", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String serverName : ServersLinkApi.getServerNames()) {
                builder.suggest(serverName);
            }
            return builder.buildFuture();
        }).executes(context -> ServerCommand.join(((class_2168)context.getSource()).method_44023(), StringArgumentType.getString((CommandContext)context, (String)"server")))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(Permissions.require((String)"server.join.other", (int)2))).executes(context -> ServerCommand.join(class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"server")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9737()).requires(Permissions.require((String)"server.join.position", (int)2))).executes(context -> ServerCommand.joinPos(class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"server"), class_2277.method_9736((CommandContext)context, (String)"position")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"whereis").requires(Permissions.require((String)"server.whereis", (int)2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ServerCommand.whereis((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tpto").requires(Permissions.require((String)"server.tpto", (int)2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ServerCommand.teleportTo((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tphere").requires(Permissions.require((String)"server.tphere", (int)2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ServerCommand.teleportHere((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"run").requires(Permissions.require((String)"server.run", (int)2))).redirect((CommandNode)dispatcher.getRoot()))));
    }

    private static int list(class_2168 source) {
        class_3222 player = source.method_44023();
        player.method_64398((class_2561)class_2561.method_43470((String)"Server List").method_27695(new class_124[]{class_124.field_1067, class_124.field_1063}));
        for (ServerInfo server : ServersLinkApi.getServerList()) {
            class_5250 status = class_2561.method_43470((String)"\u25cf");
            if (server.isDown()) {
                status.method_27692(class_124.field_1061);
            } else {
                status.method_27692(class_124.field_1060);
            }
            class_5250 players = class_2561.method_43470((String)String.valueOf(server.getPlayersList().size())).method_27692(class_124.field_1068);
            class_5250 tps = class_2561.method_43470((String)String.format(Locale.ENGLISH, "%.1f", Float.valueOf(server.getTps())));
            if (server.getTps() > 15.0f) {
                tps.method_27692(class_124.field_1060);
            } else if (server.getTps() > 10.0f) {
                tps.method_27692(class_124.field_1054);
            } else if (server.getTps() > 0.0f) {
                tps.method_27692(class_124.field_1061);
            } else {
                tps.method_27692(class_124.field_1079);
            }
            player.method_64398((class_2561)class_2561.method_43470((String)"[").method_10852((class_2561)status).method_27693("] " + server.getName()).method_27693(" | ").method_10852((class_2561)players).method_27693(" player(s)").method_27693(" (").method_10852((class_2561)tps).method_27693(" TPS)").method_27692(class_124.field_1080));
        }
        return 1;
    }

    private static int join(class_3222 player, String serverName) {
        if (player != null) {
            String name = ServersLink.getServerInfo().getName();
            ((IPlayerServersLink)player).servers_link$setServerPos(name, player.method_19538());
            if (name.equals(serverName)) {
                player.method_64398((class_2561)class_2561.method_43470((String)"You are already connected to this server").method_27692(class_124.field_1061));
            } else if (ServersLinkApi.getServer(serverName) == null) {
                player.method_64398((class_2561)class_2561.method_43470((String)"This server does not exist").method_27692(class_124.field_1061));
            } else {
                ServersLinkApi.transferPlayer(player, ServersLink.getServerInfo().getName(), serverName);
            }
        }
        return 1;
    }

    private static int joinPos(class_3222 player, String serverName, class_243 pos) {
        ((IPlayerServersLink)player).servers_link$setServerPos(serverName, pos);
        return ServerCommand.join(player, serverName);
    }

    private static int whereis(class_2168 source, class_3222 player) {
        class_3222 sender = source.method_44023();
        sender.method_64398((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + " is on " + ServersLinkApi.whereIs(player.method_5667()))));
        return 1;
    }

    private static int teleportTo(class_2168 source, class_3222 player) {
        class_3222 sender = source.method_44023();
        String server = ServersLinkApi.whereIs(player.method_5667());
        if (sender == null) {
            return 0;
        }
        if (server.equals(ServersLink.getServerInfo().getName())) {
            sender.method_48105(player.method_51469(), player.method_23317(), player.method_23318(), player.method_23321(), EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455(), false);
        } else {
            TeleportationRequestPacket request = new TeleportationRequestPacket(player.method_5667(), sender.method_5667(), ServersLink.getServerInfo().getName(), server);
            if (ServersLink.isGateway) {
                Gateway.getInstance().sendTo(request, server);
            } else {
                SubServer.getInstance().send(request);
            }
        }
        return 1;
    }

    private static int teleportHere(class_2168 source, class_3222 player) {
        class_3222 sender = source.method_44023();
        String server = ServersLinkApi.whereIs(player.method_5667());
        if (sender == null) {
            return 0;
        }
        if (server.equals(ServersLink.getServerInfo().getName())) {
            player.method_48105(sender.method_51469(), sender.method_23317(), sender.method_23318(), sender.method_23321(), EnumSet.noneOf(class_2709.class), sender.method_36454(), sender.method_36455(), false);
        } else {
            TeleportationAcceptPacket accept = new TeleportationAcceptPacket(sender.method_23317(), sender.method_23318(), sender.method_23321(), player.method_5667(), server, ServersLink.getServerInfo().getName());
            if (ServersLink.isGateway) {
                Gateway.getInstance().sendTo(accept, server);
            } else {
                SubServer.getInstance().send(accept);
            }
        }
        return 1;
    }
}

