/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.mixin;

import io.github.kgriff0n.ServersLink;
import io.github.kgriff0n.api.ServersLinkApi;
import io.github.kgriff0n.packet.play.SystemChatPacket;
import io.github.kgriff0n.packet.server.PlayerDataPacket;
import io.github.kgriff0n.util.DummyPlayer;
import java.io.IOException;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_7225;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3324.class})
public abstract class PlayerManagerMixin {
    @Unique
    private class_3222 player;

    @Shadow
    public abstract void method_43514(class_2561 var1, boolean var2);

    @Inject(at={@At(value="HEAD")}, method={"broadcast(Lnet/minecraft/text/Text;Z)V"})
    private void sendSystemPacket(class_2561 message, boolean overlay, CallbackInfo ci) {
        SystemChatPacket packet = new SystemChatPacket(class_2561.class_2562.method_10867((class_2561)message, (class_7225.class_7874)ServersLink.SERVER.method_30611()));
        ServersLinkApi.send(packet, ServersLink.getServerInfo().getName());
    }

    @Inject(at={@At(value="HEAD")}, method={"onPlayerConnect"})
    private void getPlayer(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        this.player = player;
    }

    @Inject(at={@At(value="TAIL")}, method={"savePlayerData"})
    private void sendPlayerData(class_3222 player, CallbackInfo ci) {
        try {
            ServersLinkApi.send(new PlayerDataPacket(player.method_5667()), ServersLink.getServerInfo().getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Redirect(method={"onPlayerConnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;broadcast(Lnet/minecraft/text/Text;Z)V"))
    private void preventConnectMessage(class_3324 instance, class_2561 message, boolean overlay) {
        if (ServersLinkApi.getPreventConnect().contains(this.player.method_5667())) {
            ServersLinkApi.getPreventConnect().remove(this.player.method_5667());
        } else {
            this.method_43514(message, overlay);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"savePlayerData"}, cancellable=true)
    private void savePlayerDataThreadSafe(class_3222 player, CallbackInfo ci) {
        if (player instanceof DummyPlayer) {
            ci.cancel();
        }
    }
}

