/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.socket;

import com.mojang.authlib.GameProfile;
import io.github.kgriff0n.ServersLink;
import io.github.kgriff0n.api.ServersLinkApi;
import io.github.kgriff0n.packet.Packet;
import io.github.kgriff0n.packet.info.NewPlayerPacket;
import io.github.kgriff0n.packet.info.NewServerPacket;
import io.github.kgriff0n.server.Group;
import io.github.kgriff0n.server.ServerInfo;
import io.github.kgriff0n.server.Settings;
import io.github.kgriff0n.socket.Gateway;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class G2SConnection
extends Thread {
    private ServerInfo server;
    private final Socket socket;
    private ObjectInputStream in;
    private ObjectOutputStream out;

    public G2SConnection(Socket socket) {
        this.socket = socket;
    }

    public synchronized void send(Packet packet) {
        try {
            this.out.writeObject(packet);
            this.out.flush();
            this.out.reset();
        }
        catch (IOException e) {
            ServersLink.LOGGER.error("Unable to send packet: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void run() {
        try {
            this.out = new ObjectOutputStream(this.socket.getOutputStream());
            this.out.flush();
            this.in = new ObjectInputStream(this.socket.getInputStream());
            while (ServersLink.IS_RUNNING) {
                Packet packet = (Packet)this.in.readObject();
                if (Gateway.getInstance().isDebugEnabled()) {
                    ServersLink.LOGGER.info("\u001b[95mPacket received {}", packet.getClass());
                }
                if (packet instanceof NewServerPacket) {
                    Group serverGroup;
                    NewServerPacket pkt = (NewServerPacket)packet;
                    this.server = pkt.getServer();
                    this.setName(String.format("%s thread", this.server.getName()));
                    ServersLinkApi.addServer(this.server, this);
                    Gateway.getInstance().getGroup(this.server.getGroupId()).addServer(this.server);
                    ServersLink.LOGGER.info("Add {} sub-server", (Object)this.server.getName());
                    Settings globalSettings = Gateway.getInstance().getGroup("global").getSettings();
                    Settings serverSettings = Gateway.getInstance().getGroup(this.server.getGroupId()).getSettings();
                    if (globalSettings.isPlayerListSynced() && serverSettings.isPlayerListSynced()) {
                        for (class_3222 player : ServersLink.SERVER.method_3760().method_14571()) {
                            this.send(new NewPlayerPacket(player.method_7334()));
                        }
                    } else if (!globalSettings.isPlayerListSynced() && serverSettings.isPlayerListSynced() && (serverGroup = Gateway.getInstance().getGroup(this.server.getGroupId())).getServersList().size() > 1) {
                        for (ServerInfo serverInfo : serverGroup.getServersList()) {
                            if (serverInfo.getName().equals(this.server.getName())) continue;
                            for (GameProfile profile : serverInfo.getGameProfile()) {
                                this.send(new NewPlayerPacket(profile));
                            }
                            break;
                        }
                    }
                }
                packet.onGatewayReceive(this.server.getName());
            }
            this.socket.close();
        }
        catch (IOException e) {
            ServersLink.LOGGER.error("Error {} in sub-server {}", (Object)e.getMessage(), (Object)this.server.getName());
            ServersLink.LOGGER.info(this.server.toString());
            ServersLinkApi.disconnectServer(this.server);
            ServersLinkApi.broadcastToOp((class_2561)class_2561.method_43470((String)("Sub-server " + this.server.getName() + " has disconnected")).method_27692(class_124.field_1061));
        }
        catch (ClassNotFoundException e) {
            ServersLink.LOGGER.error("Receive invalid data: {}", (Object)e.getMessage());
        }
    }
}

