/*
 * Decompiled with CFR 0.152.
 */
package io.github.kgriff0n.socket;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.kgriff0n.ServersLink;
import io.github.kgriff0n.api.ServersLinkApi;
import io.github.kgriff0n.packet.Packet;
import io.github.kgriff0n.server.Group;
import io.github.kgriff0n.server.ServerInfo;
import io.github.kgriff0n.server.Settings;
import io.github.kgriff0n.socket.G2SConnection;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Gateway
extends Thread {
    public static Gateway gateway;
    private HashMap<String, Group> groups;
    private ServerSocket serverSocket;
    private boolean debug;
    private boolean whitelistIp;
    private final List<String> whitelistedIp = new ArrayList<String>();
    private boolean reconnectLastServer;

    public Gateway(int port) {
        if (gateway != null) {
            ServersLink.LOGGER.info("Gateway server already started");
        }
        try {
            this.serverSocket = new ServerSocket(port);
            gateway = this;
            this.groups = new HashMap();
            this.loadGroups();
            ServersLinkApi.addServer(ServersLink.getServerInfo(), null);
        }
        catch (IOException e) {
            ServersLink.LOGGER.info("Unable to start central server");
        }
    }

    public static Gateway getInstance() {
        return gateway;
    }

    public void sendAll(Packet packet) {
        for (G2SConnection sub : ServersLinkApi.getServerMap().values()) {
            if (sub == null) continue;
            sub.send(packet);
        }
    }

    public void sendTo(Packet packet, String serverName) {
        if (serverName.equals(ServersLink.getServerInfo().getName())) {
            packet.onReceive();
        } else {
            for (ServerInfo server : ServersLinkApi.getServerList()) {
                if (!server.getName().equals(serverName)) continue;
                ServersLinkApi.getServerMap().get(server).send(packet);
            }
        }
    }

    public void forward(Packet packet, String sourceServer) {
        String sourceGroup = ServersLinkApi.getServer(sourceServer).getGroupId();
        for (ServerInfo server : ServersLinkApi.getServerList()) {
            G2SConnection sub = ServersLinkApi.getServerMap().get(server);
            if (sub == null || server.getName().equals(sourceServer)) continue;
            if (this.isDebugEnabled()) {
                ServersLink.LOGGER.info("\u001b[33mForward packet {} to {}?", (Object)packet.getClass().getName(), (Object)server.getName());
            }
            if (packet.shouldReceive(this.getSettings(sourceGroup, server.getGroupId()))) {
                if (this.isDebugEnabled()) {
                    ServersLink.LOGGER.info("\u001b[32mYes");
                }
                sub.send(packet);
                continue;
            }
            if (!this.isDebugEnabled()) continue;
            ServersLink.LOGGER.info("\u001b[31mNo");
        }
    }

    public void removePlayer(UUID uuid) {
        for (ServerInfo server : ServersLinkApi.getServerList()) {
            server.removePlayer(uuid);
        }
    }

    public boolean isConnectedPlayer(UUID uuid) {
        for (ServerInfo server : ServersLinkApi.getServerList()) {
            if (!server.getPlayersList().containsKey(uuid)) continue;
            return true;
        }
        return false;
    }

    public Settings getSettings(String sourceGroup, String destinationGroup) {
        Group a = this.groups.get(sourceGroup);
        if (a.getRules().containsKey(destinationGroup)) {
            return a.getRules().get(destinationGroup);
        }
        if (sourceGroup.equals(destinationGroup)) {
            return a.getSettings();
        }
        return this.groups.get("global").getSettings();
    }

    public Group getGroup(String groupId) {
        return this.groups.get(groupId);
    }

    public void loadConfig() {
        Path path = ServersLink.CONFIG.resolve("config.json");
        try {
            String jsonContent = Files.readString(path);
            Gson gson = new Gson();
            JsonObject jsonObject = (JsonObject)gson.fromJson(jsonContent, JsonObject.class);
            this.debug = jsonObject.get("debug").getAsBoolean();
            this.whitelistIp = jsonObject.get("whitelist_ip").getAsBoolean();
            for (JsonElement element : jsonObject.getAsJsonArray("whitelisted_ip")) {
                this.whitelistedIp.add(element.getAsString());
            }
            this.reconnectLastServer = jsonObject.get("reconnect_last_server").getAsBoolean();
        }
        catch (IOException e) {
            ServersLink.LOGGER.error("Unable to read config.json");
        }
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public boolean hasWhitelistIp() {
        return this.whitelistIp;
    }

    public List<String> getWhitelistedIp() {
        return this.whitelistedIp;
    }

    public boolean shouldReconnectToLastServer() {
        return this.reconnectLastServer;
    }

    private void loadGroups() {
        Path path = ServersLink.CONFIG.resolve("groups.json");
        try {
            String jsonContent = Files.readString(path);
            Gson gson = new Gson();
            JsonObject jsonObject = (JsonObject)gson.fromJson(jsonContent, JsonObject.class);
            JsonObject jsonGroups = jsonObject.getAsJsonObject("groups");
            JsonObject global = jsonGroups.getAsJsonObject("global");
            Settings globalSettings = new Settings(global.get("player_list").getAsBoolean(), global.get("chat").getAsBoolean(), global.get("player_data").getAsBoolean(), global.get("whitelist").getAsBoolean(), global.get("roles").getAsBoolean());
            this.groups.put("global", new Group(globalSettings));
            for (Map.Entry entry : jsonGroups.entrySet()) {
                JsonObject otherGroup = ((JsonElement)entry.getValue()).getAsJsonObject();
                Settings otherSettings = new Settings(otherGroup.has("player_list") ? otherGroup.get("player_list").getAsBoolean() : globalSettings.isPlayerListSynced(), otherGroup.has("chat") ? otherGroup.get("chat").getAsBoolean() : globalSettings.isChatSynced(), otherGroup.has("player_data") ? otherGroup.get("player_data").getAsBoolean() : globalSettings.isPlayerDataSynced(), otherGroup.has("whitelist") ? otherGroup.get("whitelist").getAsBoolean() : globalSettings.isWhitelistSynced(), otherGroup.has("roles") ? otherGroup.get("roles").getAsBoolean() : globalSettings.isRolesSynced());
                if (((String)entry.getKey()).equals("global")) continue;
                this.groups.put((String)entry.getKey(), new Group(otherSettings));
            }
            JsonArray jsonRules = jsonObject.get("rules").getAsJsonArray();
            for (JsonElement element : jsonRules) {
                JsonObject rule = element.getAsJsonObject();
                JsonArray ruleGroups = rule.getAsJsonArray("groups");
                Settings ruleSettings = new Settings(rule.has("player_list") ? rule.get("player_list").getAsBoolean() : globalSettings.isPlayerListSynced(), rule.has("chat") ? rule.get("chat").getAsBoolean() : globalSettings.isChatSynced(), rule.has("player_data") ? rule.get("player_data").getAsBoolean() : globalSettings.isPlayerDataSynced(), rule.has("whitelist") ? rule.get("whitelist").getAsBoolean() : globalSettings.isWhitelistSynced(), rule.has("roles") ? rule.get("roles").getAsBoolean() : globalSettings.isRolesSynced());
                for (int i = 0; i < ruleGroups.size(); ++i) {
                    String groupId = ruleGroups.get(i).getAsString();
                    for (int j = 0; j < ruleGroups.size(); ++j) {
                        if (i == j) continue;
                        this.groups.get(groupId).addRule(ruleGroups.get(j).getAsString(), ruleSettings);
                    }
                }
            }
        }
        catch (IOException e) {
            ServersLink.LOGGER.error("Unable to read groups.json");
        }
    }

    @Override
    public void run() {
        while (ServersLink.IS_RUNNING) {
            try {
                G2SConnection connection;
                Socket socket = this.serverSocket.accept();
                if (this.whitelistIp) {
                    if (this.whitelistedIp.contains(socket.getInetAddress().getHostAddress())) {
                        connection = new G2SConnection(socket);
                        connection.start();
                        continue;
                    }
                    ServersLink.LOGGER.warn("Unauthorized connection received from {}", (Object)socket.getInetAddress().getHostAddress());
                    socket.close();
                    continue;
                }
                connection = new G2SConnection(socket);
                connection.start();
            }
            catch (IOException e) {
                ServersLink.LOGGER.info("Unable to accept connection");
            }
        }
    }
}

