package thelm.jaopca.api.fluids;

import java.util.Collections;
import java.util.List;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class PlaceableFluidBlock extends Block implements IBucketPickupHandler {

	protected final StateContainer<Block, BlockState> stateContainer;

	protected final PlaceableFluid fluid;
	protected final int maxLevel;
	protected final IntegerProperty levelProperty;

	public PlaceableFluidBlock(Block.Properties properties, PlaceableFluid fluid, int maxLevel) {
		super(properties);

		this.fluid = fluid;
		this.maxLevel = maxLevel;
		levelProperty = IntegerProperty.func_177719_a("level", 0, maxLevel);

		StateContainer.Builder<Block, BlockState> builder = new StateContainer.Builder<>(this);
		func_206840_a(builder);
		stateContainer = builder.func_235882_a_(Block::func_176223_P, BlockState::new);
		func_180632_j(stateContainer.func_177621_b().func_206870_a(levelProperty, maxLevel));
	}

	public IntegerProperty getLevelProperty() {
		return levelProperty;
	}

	@Override
	public void func_225542_b_(BlockState blockState, ServerWorld world, BlockPos pos, Random random) {
		world.func_204610_c(pos).func_206891_b(world, pos, random);
	}

	@Override
	public boolean func_200123_i(BlockState blockState, IBlockReader reader, BlockPos pos) {
		return false;
	}

	@Override
	public boolean func_196266_a(BlockState blockState, IBlockReader world, BlockPos pos, PathType type) {
		return !fluid.func_207185_a(FluidTags.field_206960_b);
	}

	@Override
	public FluidState func_204507_t(BlockState blockState) {
		IntegerProperty fluidLevelProperty = fluid.getLevelProperty();
		int blockLevel = blockState.func_177229_b(levelProperty);
		int fluidLevel = blockLevel >= maxLevel ? maxLevel+1 : maxLevel-blockLevel;
		return fluid.func_207188_f().func_206870_a(fluidLevelProperty, fluidLevel);
	}

	@OnlyIn(Dist.CLIENT)
	@Override
	public boolean func_200122_a(BlockState blockState, BlockState adjacentBlockState, Direction side) {
		return adjacentBlockState.func_204520_s().func_206886_c().func_207187_a(fluid);
	}

	@Override
	public BlockRenderType func_149645_b(BlockState blockState) {
		return BlockRenderType.INVISIBLE;
	}

	@Override
	public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
		return Collections.emptyList();
	}

	@Override
	public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
		return VoxelShapes.func_197880_a();
	}

	@Override
	public void func_220082_b(BlockState blockState, World world, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
		if(reactWithNeighbors(world, pos, blockState)) {
			world.func_205219_F_().func_205360_a(pos, blockState.func_204520_s().func_206886_c(), fluid.func_205569_a(world));
		}
	}

	@Override
	public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
		if(blockState.func_204520_s().func_206889_d() || facingState.func_204520_s().func_206889_d()) {
			world.func_205219_F_().func_205360_a(currentPos, blockState.func_204520_s().func_206886_c(), fluid.func_205569_a(world));
		}
		return super.func_196271_a(blockState, facing, facingState, world, currentPos, facingPos);
	}

	@Override
	public void func_220069_a(BlockState blockState, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
		if(reactWithNeighbors(world, pos, blockState)) {
			world.func_205219_F_().func_205360_a(pos, blockState.func_204520_s().func_206886_c(), fluid.func_205569_a(world));
		}
	}

	public boolean reactWithNeighbors(World world, BlockPos pos, BlockState blockState) {
		return true;
	}

	@Override
	protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
		if(levelProperty != null) {
			builder.func_206894_a(levelProperty);
		}
	}

	@Override
	public StateContainer<Block, BlockState> func_176194_O() {
		return stateContainer;
	}

	@Override
	public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState blockState) {
		if(blockState.func_177229_b(levelProperty) == 0) {
			world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
			return fluid;
		}
		else {
			return Fluids.field_204541_a;
		}
	}
}
