package thelm.jaopca.compat.mekanism.slurries;

import java.util.function.Supplier;

import com.google.common.base.Strings;

import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryBuilder;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.mekanism.api.slurries.IMaterialFormSlurry;
import thelm.jaopca.compat.mekanism.api.slurries.ISlurryFormSettings;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCASlurry extends Slurry implements IMaterialFormSlurry {

	private final IForm form;
	private final IMaterial material;
	protected final ISlurryFormSettings settings;

	protected boolean isHidden;
	protected Supplier<String> oreTag;

	public JAOPCASlurry(IForm form, IMaterial material, ISlurryFormSettings settings) {
		super(SlurryBuilder.builder(new ResourceLocation("jaopca", "slurry/"+material.getModelType()+'/'+form.getName())));
		this.form = form;
		this.material = material;
		this.settings = settings;

		isHidden = settings.getIsHidden();
		oreTag = MemoizingSuppliers.of(()->settings.getOreTagFunction().apply(material));
	}

	@Override
	public IForm getForm() {
		return form;
	}

	@Override
	public IMaterial getMaterial() {
		return material;
	}

	@Override
	public boolean isHidden() {
		return isHidden;
	}

	@Override
	public ITag<Item> getOreTag() {
		String oreTag = this.oreTag.get();
		return Strings.isNullOrEmpty(oreTag) ? null : MiscHelper.INSTANCE.getItemTag(new ResourceLocation(oreTag));
	}

	@Override
	public int getTint() {
		return 0xFFFFFF & material.getColor();
	}

	@Override
	public ResourceLocation getIcon() {
		if(MiscHelper.INSTANCE.hasResource(
				new ResourceLocation(getRegistryName().func_110624_b(),
						"textures/slurry/"+getRegistryName().func_110623_a()+".png"))) {
			return new ResourceLocation(getRegistryName().func_110624_b(),
					"slurry/"+getRegistryName().func_110623_a());
		}
		return super.getIcon();
	}

	@Override
	public ITextComponent getTextComponent() {
		return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("slurry.jaopca."+form.getName(), material, getTranslationKey());
	}
}
