package thelm.jaopca.compat.thermalexpansion;

import java.util.Arrays;
import java.util.function.Supplier;

import com.google.gson.JsonElement;

import cofh.lib.fluid.FluidIngredient;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.fluids.IFluidProvider;
import thelm.jaopca.compat.thermalexpansion.recipes.ChillerRecipeSupplier;
import thelm.jaopca.compat.thermalexpansion.recipes.PressRecipeSupplier;
import thelm.jaopca.compat.thermalexpansion.recipes.PulverizerRecipeSupplier;
import thelm.jaopca.compat.thermalexpansion.recipes.SmelterRecipeSupplier;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class ThermalExpansionHelper {

	public static final ThermalExpansionHelper INSTANCE = new ThermalExpansionHelper();

	private ThermalExpansionHelper() {}

	public Ingredient getCountedIngredient(Object obj, int count) {
		Ingredient ing = MiscHelper.INSTANCE.getIngredient(obj);
		for(ItemStack stack : ing.func_193365_a()) {
			stack.func_190920_e(count);
		}
		return ing;
	}

	public FluidIngredient getFluidIngredient(Object obj, int amount) {
		if(obj instanceof Supplier<?>) {
			return getFluidIngredient(((Supplier<?>)obj).get(), amount);
		}
		else if(obj instanceof FluidIngredient) {
			return (FluidIngredient)obj;
		}
		else if(obj instanceof String) { // Tag fluid ingredients are broken right now
			return FluidIngredient.of(MiscHelper.INSTANCE.getFluidTag(new ResourceLocation((String)obj)).func_230236_b_().stream().map(f->new FluidStack(f, amount)).toArray(FluidStack[]::new));
		}
		else if(obj instanceof ResourceLocation) {
			return FluidIngredient.of(MiscHelper.INSTANCE.getFluidTag((ResourceLocation)obj).func_230236_b_().stream().map(f->new FluidStack(f, amount)).toArray(FluidStack[]::new));
		}
		else if(obj instanceof ITag<?>) {
			return FluidIngredient.of(((ITag<Fluid>)obj).func_230236_b_().stream().map(f->new FluidStack(f, amount)).toArray(FluidStack[]::new));
		}
		else if(obj instanceof FluidStack) {
			FluidStack stack = (FluidStack)obj;
			if(!stack.isEmpty()) {
				return FluidIngredient.of(stack);
			}
		}
		else if(obj instanceof FluidStack[]) {
			return FluidIngredient.of(Arrays.stream((FluidStack[])obj).filter(s->!s.isEmpty()).toArray(FluidStack[]::new));
		}
		else if(obj instanceof Fluid) {
			if(obj != Fluids.field_204541_a) {
				return FluidIngredient.of(new FluidStack((Fluid)obj, amount));
			}
		}
		else if(obj instanceof Fluid[]) {
			return FluidIngredient.of(Arrays.stream((Fluid[])obj).filter(f->f != Fluids.field_204541_a).map(f->new FluidStack(f, amount)).toArray(FluidStack[]::new));
		}
		else if(obj instanceof IFluidProvider) {
			Fluid fluid = ((IFluidProvider)obj).asFluid();
			if(fluid != Fluids.field_204541_a) {
				return FluidIngredient.of(new FluidStack(fluid, amount));
			}
		}
		else if(obj instanceof IFluidProvider[]) {
			return FluidIngredient.of(Arrays.stream((IFluidProvider[])obj).map(IFluidProvider::asFluid).filter(f->f != Fluids.field_204541_a).map(f->new FluidStack(f, amount)).toArray(FluidStack[]::new));
		}
		else if(obj instanceof JsonElement) {
			return FluidIngredient.fromJson((JsonElement)obj);
		}
		return FluidIngredient.of();
	}

	public boolean registerPulverizerRecipe(ResourceLocation key, Object input, int inputCount, Object[] output, int energy, float experience) {
		return ApiImpl.INSTANCE.registerRecipe(key, new PulverizerRecipeSupplier(key, input, inputCount, output, energy, experience));
	}

	public boolean registerSmelterRecipe(ResourceLocation key, Object[] input, Object[] output, int energy, float experience) {
		return ApiImpl.INSTANCE.registerRecipe(key, new SmelterRecipeSupplier(key, input, output, energy, experience));
	}

	public boolean registerPressRecipe(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, Object fluidOutput, int fluidOutputAmount, int energy, float experience) {
		return ApiImpl.INSTANCE.registerRecipe(key, new PressRecipeSupplier(key, input, inputCount, secondInput, secondInputCount, itemOutput, itemOutputCount, fluidOutput, fluidOutputAmount, energy, experience));
	}

	public boolean registerPressRecipe(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, int energy, float experience) {
		return ApiImpl.INSTANCE.registerRecipe(key, new PressRecipeSupplier(key, input, inputCount, secondInput, secondInputCount, itemOutput, itemOutputCount, energy, experience));
	}

	public boolean registerPressRecipe(ResourceLocation key, Object input, int inputCount, Object itemOutput, int itemOutputCount, int energy, float experience) {
		return ApiImpl.INSTANCE.registerRecipe(key, new PressRecipeSupplier(key, input, inputCount, itemOutput, itemOutputCount, energy, experience));
	}

	public boolean registerChillerRecipe(ResourceLocation key, Object fluidInput, int fluidInputAmount, Object itemInput, int itemInputCount, Object output, int outputCount, int energy, float experience) {
		return ApiImpl.INSTANCE.registerRecipe(key, new ChillerRecipeSupplier(key, fluidInput, fluidInputAmount, itemInput, itemInputCount, output, outputCount, energy, experience));
	}
}
