package thelm.jaopca.fluids;

import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABucketItem extends Item implements IMaterialFormBucketItem {

	private final IMaterialFormFluid fluid;
	private final IFluidFormSettings settings;

	protected IntSupplier itemStackLimit;
	protected BooleanSupplier hasEffect;
	protected Supplier<Rarity> rarity;
	protected IntSupplier burnTime;

	public JAOPCABucketItem(IMaterialFormFluid fluid, IFluidFormSettings settings) {
		super(new Item.Properties().func_200919_a(Items.field_151133_ar).func_200916_a(ItemFormType.getItemGroup()));
		this.fluid = fluid;
		this.settings = settings;

		itemStackLimit = MemoizingSuppliers.of(settings.getItemStackLimitFunction(), fluid::getMaterial);
		hasEffect = MemoizingSuppliers.of(settings.getHasEffectFunction(), fluid::getMaterial);
		rarity = MemoizingSuppliers.of(settings.getDisplayRarityFunction(), fluid::getMaterial);
		burnTime = MemoizingSuppliers.of(settings.getBurnTimeFunction(), fluid::getMaterial);
	}

	@Override
	public IForm getForm() {
		return fluid.getForm();
	}

	@Override
	public IMaterial getMaterial() {
		return fluid.getMaterial();
	}

	@Override
	public int getItemStackLimit(ItemStack stack) {
		return itemStackLimit.getAsInt();
	}

	@Override
	public boolean func_77636_d(ItemStack stack) {
		return hasEffect.getAsBoolean() || super.func_77636_d(stack);
	}

	@Override
	public Rarity func_77613_e(ItemStack stack) {
		return rarity.get();
	}

	@Override
	public int getBurnTime(ItemStack itemStack) {
		return burnTime.getAsInt();
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
		ItemStack stack = player.func_184586_b(hand);
		RayTraceResult rayTraceResult = func_219968_a(world, player, RayTraceContext.FluidMode.NONE);
		ActionResult<ItemStack> ret = ForgeEventFactory.onBucketUse(player, world, stack, rayTraceResult);
		if(ret != null) {
			return ret;
		}
		if(rayTraceResult.func_216346_c() == RayTraceResult.Type.MISS) {
			return new ActionResult<>(ActionResultType.PASS, stack);
		}
		else if(rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
			return new ActionResult<>(ActionResultType.PASS, stack);
		}
		else {
			BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
			BlockPos resultPos = blockRayTraceResult.func_216350_a();
			if(world.func_175660_a(player, resultPos) && player.func_175151_a(resultPos, blockRayTraceResult.func_216354_b(), stack)) {
				BlockPos pos = blockRayTraceResult.func_216350_a().func_177972_a(blockRayTraceResult.func_216354_b());
				if(tryPlaceContainedLiquid(player, world, pos, blockRayTraceResult)) {
					onLiquidPlaced(world, stack, pos);
					if(player instanceof ServerPlayerEntity) {
						CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
					}
					player.func_71029_a(Stats.field_75929_E.func_199076_b(this));
					return new ActionResult<>(ActionResultType.SUCCESS, emptyBucket(stack, player));
				}
				else {
					return new ActionResult<>(ActionResultType.FAIL, stack);
				}
			}
			else {
				return new ActionResult<>(ActionResultType.FAIL, stack);
			}
		}
	}

	protected ItemStack emptyBucket(ItemStack stack, PlayerEntity player) {
		return !player.field_71075_bZ.field_75098_d ? new ItemStack(Items.field_151133_ar) : stack;
	}

	public void onLiquidPlaced(World world, ItemStack stack, BlockPos pos) {}

	public boolean tryPlaceContainedLiquid(PlayerEntity player, World world, BlockPos pos, BlockRayTraceResult rayTraceResult) {
		BlockState blockState = world.func_180495_p(pos);
		Material blockMaterial = blockState.func_185904_a();
		boolean flag = !blockMaterial.func_76220_a();
		boolean flag1 = blockMaterial.func_76222_j();
		if(world.func_175623_d(pos) || flag || flag1) {
			FluidStack stack = new FluidStack(fluid.toFluid(), FluidAttributes.BUCKET_VOLUME);
			if(world.func_230315_m_().func_236040_e_() && fluid.toFluid().func_207185_a(FluidTags.field_206959_a)) {
				int i = pos.func_177958_n();
				int j = pos.func_177956_o();
				int k = pos.func_177952_p();
				world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5F, 2.6F+(world.field_73012_v.nextFloat()-world.field_73012_v.nextFloat())*0.8F);
				for(int l = 0; l < 8; ++l) {
					world.func_195594_a(ParticleTypes.field_197594_E, i+Math.random(), j+Math.random(), k+Math.random(), 0, 0, 0);
				}
			}
			else {
				if(!world.field_72995_K && (flag || flag1) && !blockMaterial.func_76224_d()) {
					world.func_175655_b(pos, true);
				}
				playEmptySound(player, world, pos);
				world.func_180501_a(pos, fluid.toFluid().getAttributes().getStateForPlacement(world, pos, stack).func_206883_i(), 11);
			}
			return true;
		}
		else {
			return rayTraceResult == null ? false : tryPlaceContainedLiquid(player, world, rayTraceResult.func_216350_a().func_177972_a(rayTraceResult.func_216354_b()), null);
		}
	}

	protected void playEmptySound(PlayerEntity player, IWorld world, BlockPos pos) {
		SoundEvent soundEvent = fluid.toFluid().getAttributes().getEmptySound();
		if(soundEvent == null) {
			soundEvent = fluid.toFluid().func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
		}
		world.func_184133_a(player, pos, soundEvent, SoundCategory.BLOCKS, 1, 1);
	}

	@Override
	public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
		return new JAOPCAFluidHandlerItem(fluid, stack);
	}

	@Override
	public ITextComponent func_200295_i(ItemStack stack) {
		return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("item.jaopca."+getForm().getName(), getMaterial(), func_77667_c(stack));
	}
}
