package thelm.jaopca.localization;

import java.util.Objects;
import java.util.TreeMap;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraftforge.fml.DistExecutor;
import thelm.jaopca.api.localization.ILocalizer;

public class LocalizationHandler {

	private static final TreeMap<String, ILocalizer> LOCALIZERS = new TreeMap<>();

	public static void registerLocalizer(ILocalizer localizer, String... languages) {
		Objects.requireNonNull(localizer);
		for(String language : Objects.requireNonNull(languages)) {
			LOCALIZERS.put(language, localizer);
		}
	}

	public static ILocalizer getCurrentLocalizer() {
		return LOCALIZERS.computeIfAbsent(getLanguage(), key->LocalizerDefault.INSTANCE);
	}

	public static String getLanguage() {
		return DistExecutor.unsafeRunForDist(()->()->{
			Minecraft mc = Minecraft.func_71410_x();
			if(mc != null) {
				Language lang = mc.func_135016_M().func_135041_c();
				if(lang != null) {
					return lang.getCode();
				}
				return mc.field_71474_y.field_74363_ab;
			}
			return "en_us";
		}, ()->()->"en_us");
	}
}
