/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import com.google.common.base.Strings;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABlock
extends Block
implements IMaterialFormBlock {
    private final IForm form;
    private final IMaterial material;
    protected final IBlockFormSettings settings;
    protected boolean blocksMovement;
    protected Supplier<Material> blockMaterial;
    protected Supplier<MapColor> mapColor;
    protected Supplier<SoundType> soundType;
    protected IntSupplier lightOpacity;
    protected IntSupplier lightValue;
    protected DoubleSupplier blockHardness;
    protected DoubleSupplier explosionResistance;
    protected DoubleSupplier slipperiness;
    protected AxisAlignedBB boundingBox;
    protected Supplier<String> harvestTool;
    protected IntSupplier harvestLevel;
    protected IntSupplier flammability;
    protected IntSupplier fireSpreadSpeed;
    protected BooleanSupplier isFireSource;
    protected BooleanSupplier isBeaconBase;
    protected Supplier<String> translationKey;

    public JAOPCABlock(IForm form, IMaterial material, IBlockFormSettings settings) {
        super(Material.field_151573_f);
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.blocksMovement = settings.getBlocksMovement();
        this.blockMaterial = MemoizingSuppliers.of(settings.getMaterialFunction(), () -> material);
        this.mapColor = MemoizingSuppliers.of(settings.getMapColorFunction(), () -> material);
        this.soundType = MemoizingSuppliers.of(settings.getSoundTypeFunction(), () -> material);
        this.lightOpacity = MemoizingSuppliers.of(settings.getLightOpacityFunction(), () -> material);
        this.lightValue = MemoizingSuppliers.of(settings.getLightValueFunction(), () -> material);
        this.blockHardness = MemoizingSuppliers.of(settings.getBlockHardnessFunction(), () -> material);
        this.explosionResistance = MemoizingSuppliers.of(settings.getExplosionResistanceFunction(), () -> material);
        this.slipperiness = MemoizingSuppliers.of(settings.getSlipperinessFunction(), () -> material);
        this.boundingBox = settings.getBoundingBox();
        this.harvestTool = MemoizingSuppliers.of(settings.getHarvestToolFunction(), () -> material);
        this.harvestLevel = MemoizingSuppliers.of(settings.getHarvestLevelFunction(), () -> material);
        this.flammability = MemoizingSuppliers.of(settings.getFlammabilityFunction(), () -> material);
        this.fireSpreadSpeed = MemoizingSuppliers.of(settings.getFireSpreadSpeedFunction(), () -> material);
        this.isFireSource = MemoizingSuppliers.of(settings.getIsFireSourceFunction(), () -> material);
        this.isBeaconBase = MemoizingSuppliers.of(settings.getIsBeaconBaseFunction(), () -> material);
        this.translationKey = MemoizingSuppliers.of(() -> {
            ResourceLocation id = this.getRegistryName();
            return "block." + id.func_110624_b() + "." + id.func_110623_a().replace('/', '.');
        });
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public Material func_149688_o(IBlockState state) {
        return this.blockMaterial.get();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.mapColor.get();
    }

    public SoundType func_185467_w() {
        return this.soundType.get();
    }

    public int func_149717_k(IBlockState state) {
        return this.lightOpacity.getAsInt();
    }

    public int func_149750_m(IBlockState state) {
        return this.lightValue.getAsInt();
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return (float)this.blockHardness.getAsDouble();
    }

    public float func_149638_a(Entity exploder) {
        return (float)this.explosionResistance.getAsDouble();
    }

    public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return (float)this.slipperiness.getAsDouble();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.blocksMovement ? blockState.func_185900_c(worldIn, pos) : field_185506_k;
    }

    public String getHarvestTool(IBlockState state) {
        return Strings.emptyToNull((String)this.harvestTool.get());
    }

    public int getHarvestLevel(IBlockState state) {
        return this.harvestLevel.getAsInt();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.isFireSource.getAsBoolean();
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return this.isBeaconBase.getAsBoolean();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return field_185505_j.equals((Object)this.boundingBox);
    }

    public String func_149739_a() {
        return this.translationKey.get();
    }

    public String func_149732_F() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("block.jaopca." + this.form.getName(), this.material, this.func_149739_a());
    }
}

