/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materialforms.IMaterialForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABlockItem
extends ItemBlock
implements IMaterialFormBlockItem {
    protected final IBlockFormSettings settings;
    protected IntSupplier itemStackLimit;
    protected BooleanSupplier hasEffect;
    protected Supplier<EnumRarity> rarity;
    protected IntSupplier burnTime;

    public JAOPCABlockItem(IMaterialFormBlock block, IBlockFormSettings settings) {
        super(block.toBlock());
        this.settings = settings;
        this.itemStackLimit = MemoizingSuppliers.of(settings.getItemStackLimitFunction(), block::getMaterial);
        this.hasEffect = MemoizingSuppliers.of(settings.getHasEffectFunction(), block::getMaterial);
        this.rarity = MemoizingSuppliers.of(settings.getDisplayRarityFunction(), block::getMaterial);
        this.burnTime = MemoizingSuppliers.of(settings.getBurnTimeFunction(), block::getMaterial);
    }

    @Override
    public IForm getForm() {
        return ((IMaterialForm)this.func_179223_d()).getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return ((IMaterialForm)this.func_179223_d()).getMaterial();
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.itemStackLimit.getAsInt();
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.hasEffect.getAsBoolean() || super.func_77636_d(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity.get();
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return this.burnTime.getAsInt();
    }

    public String func_77653_i(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("block.jaopca." + this.getForm().getName(), this.getMaterial(), this.func_77667_c(stack));
    }
}

