/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.colors;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.vecmath.TexCoord4f;
import javax.vecmath.Tuple4f;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.oredict.OreDictionary;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materialforms.IMaterialForm;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.items.ItemFormType;

public class ColorHandler {
    public static final IBlockColor BLOCK_COLOR = (state, world, pos, tintIndex) -> {
        Block block;
        if (tintIndex == 0 && (block = state.func_177230_c()) instanceof IMaterialForm) {
            return ((IMaterialForm)block).getMaterial().getColor();
        }
        return -1;
    };
    public static final IItemColor ITEM_COLOR = (stack, tintIndex) -> {
        Item item;
        if ((tintIndex == 0 || tintIndex == 2) && (item = stack.func_77973_b()) instanceof IMaterialForm) {
            return ((IMaterialForm)item).getMaterial().getColor();
        }
        return -1;
    };

    public static void setup(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        for (IMaterialFormBlock block : BlockFormType.getBlocks()) {
            blockColors.func_186722_a(BLOCK_COLOR, new Block[]{block.toBlock()});
        }
        for (IMaterialFormBlockItem blockItem : BlockFormType.getBlockItems()) {
            itemColors.func_186730_a(ITEM_COLOR, new Item[]{blockItem.toBlockItem()});
        }
        for (IMaterialFormItem item : ItemFormType.getItems()) {
            itemColors.func_186730_a(ITEM_COLOR, new Item[]{item.toItem()});
        }
        for (IMaterialFormFluidBlock fluidBlock : FluidFormType.getFluidBlocks()) {
            blockColors.func_186722_a(BLOCK_COLOR, new Block[]{fluidBlock.toBlock()});
        }
    }

    public static int getAverageColor(String oredictName) {
        Tuple4f color = ColorHandler.weightedAverageColor((Iterable<ItemStack>)OreDictionary.getOres((String)oredictName, (boolean)false), ConfigHandler.gammaValue);
        return ColorHandler.toColorInt(color);
    }

    public static Tuple4f weightedAverageColor(Iterable<ItemStack> items, double gammaValue) {
        List<Tuple4f> colors = Streams.stream(items).map(stack -> ColorHandler.weightedAverageColor(stack, gammaValue)).collect(Collectors.toList());
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Tuple4f weightedAverageColor(ItemStack stack, double gammaValue) {
        List<BakedQuad> quads = ColorHandler.getBakedQuads(stack);
        ArrayList<Tuple4f> colors = new ArrayList<Tuple4f>();
        for (BakedQuad quad : quads) {
            Tuple4f color = ColorHandler.weightedAverageColor(quad.func_187508_a(), gammaValue);
            color = ColorHandler.tintColor(color, ColorHandler.getTint(stack, quad));
            colors.add(color);
        }
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Tuple4f weightedAverageColor(TextureAtlasSprite texture, double gammaValue) {
        int width = texture.func_94211_a();
        int height = texture.func_94216_b();
        int frameCount = texture.func_110970_k();
        ArrayList<Tuple4f> colors = new ArrayList<Tuple4f>();
        for (int frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int color = texture.func_147965_a(frameIndex)[0][y * width + x];
                    colors.add(ColorHandler.toColorTuple(color));
                }
            }
        }
        return ColorHandler.weightedAverageColor(colors, gammaValue);
    }

    public static Tuple4f weightedAverageColor(List<Tuple4f> colors, double gammaValue) {
        double totalWeight = 0.0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        for (Tuple4f color : colors) {
            totalWeight += (double)color.getW();
        }
        if (totalWeight <= 0.0) {
            return new TexCoord4f(1.0f, 1.0f, 1.0f, 0.0f);
        }
        if (gammaValue == 0.0) {
            r = 1.0;
            g = 1.0;
            b = 1.0;
            for (Tuple4f color : colors) {
                r *= (double)(color.getX() * color.getW());
                g *= (double)(color.getY() * color.getW());
                b *= (double)(color.getZ() * color.getW());
            }
            r = Math.pow(r, 1.0 / totalWeight);
            g = Math.pow(g, 1.0 / totalWeight);
            b = Math.pow(b, 1.0 / totalWeight);
        } else {
            for (Tuple4f color : colors) {
                r += Math.pow(color.getX(), gammaValue) * (double)color.getW();
                g += Math.pow(color.getY(), gammaValue) * (double)color.getW();
                b += Math.pow(color.getZ(), gammaValue) * (double)color.getW();
            }
            r = Math.pow(r / totalWeight, 1.0 / gammaValue);
            g = Math.pow(g / totalWeight, 1.0 / gammaValue);
            b = Math.pow(b / totalWeight, 1.0 / gammaValue);
        }
        return new TexCoord4f((float)MathHelper.func_151237_a((double)r, (double)0.0, (double)1.0), (float)MathHelper.func_151237_a((double)g, (double)0.0, (double)1.0), (float)MathHelper.func_151237_a((double)b, (double)0.0, (double)1.0), (float)MathHelper.func_151237_a((double)(totalWeight / (double)colors.size()), (double)0.0, (double)1.0));
    }

    public static Tuple4f toColorTuple(int color) {
        return new TexCoord4f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
    }

    public static Tuple4f tintColor(Tuple4f color, int tint) {
        return new TexCoord4f(color.getX() * (float)(tint >> 16 & 0xFF) / 255.0f, color.getY() * (float)(tint >> 8 & 0xFF) / 255.0f, color.getZ() * (float)(tint & 0xFF) / 255.0f, color.getW());
    }

    public static int toColorInt(Tuple4f color) {
        int ret = 0;
        ret |= (Math.round(MathHelper.func_76131_a((float)(color.getX() * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF) << 16;
        ret |= (Math.round(MathHelper.func_76131_a((float)(color.getY() * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF) << 8;
        return ret |= Math.round(MathHelper.func_76131_a((float)(color.getZ() * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF;
    }

    public static List<BakedQuad> getBakedQuads(ItemStack stack) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
        model.func_188616_a(null, null, 0L).stream().filter(quad -> quad.func_178210_d() == EnumFacing.SOUTH).forEach(quads::add);
        for (EnumFacing facing : EnumFacing.values()) {
            model.func_188616_a(null, facing, 0L).stream().filter(quad -> quad.func_178210_d() == EnumFacing.SOUTH).forEach(quads::add);
        }
        return quads;
    }

    public static int getTint(ItemStack stack, BakedQuad quad) {
        return Minecraft.func_71410_x().getItemColors().func_186728_a(stack, quad.func_178211_c());
    }
}

